"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EventAnnotationPlugin = void 0;
var _i18n = require("@kbn/i18n");
var _event_annotation_service = require("./event_annotation_service");
var _common = require("../common");
var _fetch_event_annotations = require("./fetch_event_annotations");
var _content_management = require("../common/content_management");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/** @public */

/** @public */
class EventAnnotationPlugin {
  setup(core, dependencies) {
    dependencies.expressions.registerFunction(_common.manualPointEventAnnotation);
    dependencies.expressions.registerFunction(_common.manualRangeEventAnnotation);
    dependencies.expressions.registerFunction(_common.queryPointEventAnnotation);
    dependencies.expressions.registerFunction(_common.eventAnnotationGroup);
    dependencies.expressions.registerFunction((0, _fetch_event_annotations.getFetchEventAnnotations)({
      getStartServices: core.getStartServices
    }));
    dependencies.contentManagement.registry.register({
      id: _content_management.CONTENT_ID,
      version: {
        latest: _content_management.LATEST_VERSION
      },
      name: _i18n.i18n.translate('eventAnnotation.content.name', {
        defaultMessage: 'Annotation group'
      })
    });
  }
  start(core, startDependencies) {
    return new _event_annotation_service.EventAnnotationService(core, startDependencies.contentManagement);
  }
}
exports.EventAnnotationPlugin = EventAnnotationPlugin;