"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KQL_FUNCTION_OR = void 0;
exports.buildNodeParams = buildNodeParams;
exports.isNode = isNode;
exports.toElasticsearchQuery = toElasticsearchQuery;
exports.toKqlExpression = toKqlExpression;
var ast = _interopRequireWildcard(require("../ast"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const KQL_FUNCTION_OR = 'or';
exports.KQL_FUNCTION_OR = KQL_FUNCTION_OR;
function isNode(node) {
  return node.function === KQL_FUNCTION_OR;
}
function buildNodeParams(children) {
  return {
    arguments: children
  };
}
function toElasticsearchQuery(node, indexPattern, config = {}, context = {}) {
  const children = node.arguments || [];
  return {
    bool: {
      should: children.map(child => {
        return ast.toElasticsearchQuery(child, indexPattern, config, context);
      }),
      minimum_should_match: 1
    }
  };
}
function toKqlExpression(node) {
  return `(${node.arguments.map(ast.toKqlExpression).join(' OR ')})`;
}