"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BooleanRelation = void 0;
exports.buildCombinedFilter = buildCombinedFilter;
exports.isCombinedFilter = isCombinedFilter;
var _types = require("./types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
/**
 * @public
 */
let BooleanRelation;
/**
 * @public
 */
exports.BooleanRelation = BooleanRelation;
(function (BooleanRelation) {
  BooleanRelation["AND"] = "AND";
  BooleanRelation["OR"] = "OR";
})(BooleanRelation || (exports.BooleanRelation = BooleanRelation = {}));
/**
 * @public
 */
/**
 * @public
 */
function isCombinedFilter(filter) {
  var _filter$meta;
  return (filter === null || filter === void 0 ? void 0 : (_filter$meta = filter.meta) === null || _filter$meta === void 0 ? void 0 : _filter$meta.type) === _types.FILTERS.COMBINED;
}
const cleanUpFilter = filter => {
  const {
    $state,
    meta,
    ...cleanedUpFilter
  } = filter;
  const {
    alias,
    disabled,
    ...cleanedUpMeta
  } = meta;
  return {
    ...cleanedUpFilter,
    meta: cleanedUpMeta
  };
};

/**
 * Builds an COMBINED filter. An COMBINED filter is a filter with multiple sub-filters. Each sub-filter (FilterItem)
 * represents a condition.
 * @param relation The type of relation with which to combine the filters (AND/OR)
 * @param filters An array of sub-filters
 * @public
 */
function buildCombinedFilter(relation, filters, indexPattern, disabled = false, negate = false, alias, store = _types.FilterStateStore.APP_STATE) {
  return {
    $state: {
      store
    },
    meta: {
      type: _types.FILTERS.COMBINED,
      relation,
      params: filters.map(cleanUpFilter),
      index: indexPattern.id,
      disabled,
      negate,
      alias
    }
  };
}