"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.cleanupESQLQueryForLensSuggestions = cleanupESQLQueryForLensSuggestions;
exports.getAggregateQueryMode = getAggregateQueryMode;
exports.getIndexPatternFromESQLQuery = getIndexPatternFromESQLQuery;
exports.getIndexPatternFromSQLQuery = getIndexPatternFromSQLQuery;
exports.getLanguageDisplayName = getLanguageDisplayName;
exports.isOfAggregateQueryType = isOfAggregateQueryType;
exports.isOfQueryType = isOfQueryType;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

// Checks if the query is of type Query
function isOfQueryType(arg) {
  return Boolean(arg && 'query' in arg);
}

// Checks if the query is of type AggregateQuery
// currently only supports the sql query type
// should be enhanced to support other query types
function isOfAggregateQueryType(query) {
  return Boolean(query && ('sql' in query || 'esql' in query));
}

// returns the language of the aggregate Query, sql, esql etc
function getAggregateQueryMode(query) {
  return Object.keys(query)[0];
}
function getLanguageDisplayName(language) {
  const displayName = language && language === 'esql' ? 'es|ql' : language !== null && language !== void 0 ? language : 'es|ql';
  return displayName.toUpperCase();
}

// retrieves the index pattern from the aggregate query for SQL
function getIndexPatternFromSQLQuery(sqlQuery) {
  var _sql, _splitFroms$length, _sql2;
  let sql = sqlQuery === null || sqlQuery === void 0 ? void 0 : sqlQuery.replaceAll('"', '').replaceAll("'", '');
  const splitFroms = (_sql = sql) === null || _sql === void 0 ? void 0 : _sql.split(new RegExp(/FROM\s/, 'ig'));
  const fromsLength = (_splitFroms$length = splitFroms === null || splitFroms === void 0 ? void 0 : splitFroms.length) !== null && _splitFroms$length !== void 0 ? _splitFroms$length : 0;
  if (splitFroms && (splitFroms === null || splitFroms === void 0 ? void 0 : splitFroms.length) > 2) {
    sql = `${splitFroms[fromsLength - 2]} FROM ${splitFroms[fromsLength - 1]}`;
  }
  // case insensitive match for the index pattern
  const regex = new RegExp(/FROM\s+([\w*-.!@$^()~;]+)/, 'i');
  const matches = (_sql2 = sql) === null || _sql2 === void 0 ? void 0 : _sql2.match(regex);
  if (matches) {
    return matches[1];
  }
  return '';
}

// retrieves the index pattern from the aggregate query for ES|QL
function getIndexPatternFromESQLQuery(esql) {
  var _esql, _splitFroms$length2, _esql2;
  const splitFroms = (_esql = esql) === null || _esql === void 0 ? void 0 : _esql.split(new RegExp(/FROM\s/, 'ig'));
  const fromsLength = (_splitFroms$length2 = splitFroms === null || splitFroms === void 0 ? void 0 : splitFroms.length) !== null && _splitFroms$length2 !== void 0 ? _splitFroms$length2 : 0;
  if (splitFroms && (splitFroms === null || splitFroms === void 0 ? void 0 : splitFroms.length) > 2) {
    esql = `${splitFroms[fromsLength - 2]} FROM ${splitFroms[fromsLength - 1]}`;
  }
  const parsedString = (_esql2 = esql) === null || _esql2 === void 0 ? void 0 : _esql2.replaceAll('`', '');
  // case insensitive match for the index pattern
  const regex = new RegExp(/FROM\s+([\w*-.!@$^()~;\s]+)/, 'i');
  const matches = parsedString === null || parsedString === void 0 ? void 0 : parsedString.match(regex);
  if (matches) {
    var _matches$;
    return (_matches$ = matches[1]) === null || _matches$ === void 0 ? void 0 : _matches$.trim();
  }
  return '';
}
function cleanupESQLQueryForLensSuggestions(esql) {
  const pipes = (esql || '').split('|');
  return pipes.filter(statement => !/DROP\s/i.test(statement)).join('|');
}