"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GithubViaAppLogic = void 0;
var _kea = require("kea");
var _flash_messages = require("../../../../../shared/flash_messages");
var _http = require("../../../../../shared/http");
var _kibana = require("../../../../../shared/kibana");
var _app_logic = require("../../../../app_logic");
var _constants = require("../../../../constants");
var _routes = require("../../../../routes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GithubViaAppLogic = (0, _kea.kea)({
  path: ['enterprise_search', 'workplace_search', 'github_via_app_logic'],
  actions: {
    setGithubAppId: githubAppId => githubAppId,
    setGithubEnterpriseServerUrl: githubEnterpriseServerUrl => githubEnterpriseServerUrl,
    createContentSource: isGithubEnterpriseServer => isGithubEnterpriseServer,
    setStagedPrivateKey: stagedPrivateKey => stagedPrivateKey,
    setButtonNotLoading: false,
    setSourceIndexPermissionsValue: indexPermissionsValue => indexPermissionsValue
  },
  reducers: {
    githubAppId: ['', {
      setGithubAppId: (_, githubAppId) => githubAppId
    }],
    githubEnterpriseServerUrl: ['', {
      setGithubEnterpriseServerUrl: (_, githubEnterpriseServerUrl) => githubEnterpriseServerUrl
    }],
    stagedPrivateKey: [null, {
      setStagedPrivateKey: (_, stagedPrivateKey) => stagedPrivateKey
    }],
    isSubmitButtonLoading: [false, {
      createContentSource: () => true,
      setButtonNotLoading: () => false
    }],
    indexPermissionsValue: [true, {
      setSourceIndexPermissionsValue: (_, indexPermissionsValue) => indexPermissionsValue,
      resetSourceState: () => false
    }]
  },
  listeners: ({
    actions,
    values
  }) => ({
    createContentSource: async isGithubEnterpriseServer => {
      const {
        isOrganization
      } = _app_logic.AppLogic.values;
      const route = isOrganization ? '/internal/workplace_search/org/create_source' : '/internal/workplace_search/account/create_source';
      const {
        githubAppId,
        githubEnterpriseServerUrl,
        stagedPrivateKey,
        indexPermissionsValue
      } = values;
      const params = {
        service_type: isGithubEnterpriseServer ? _constants.GITHUB_ENTERPRISE_SERVER_VIA_APP_SERVICE_TYPE : _constants.GITHUB_VIA_APP_SERVICE_TYPE,
        app_id: githubAppId,
        base_url: githubEnterpriseServerUrl,
        private_key: stagedPrivateKey,
        index_permissions: indexPermissionsValue
      };
      try {
        const response = await _http.HttpLogic.values.http.post(route, {
          body: JSON.stringify({
            ...params
          })
        });
        _kibana.KibanaLogic.values.navigateToUrl(`${(0, _routes.getSourcesPath)(_routes.SOURCES_PATH, isOrganization)}`);
        (0, _flash_messages.flashSuccessToast)(`${response.serviceName} connected`);
      } catch (e) {
        (0, _flash_messages.flashAPIErrors)(e);
      } finally {
        actions.setButtonNotLoading();
      }
    }
  })
});
exports.GithubViaAppLogic = GithubViaAppLogic;