"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RolesEmptyPrompt = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _kibana_logic = require("../kibana/kibana_logic");
var _constants = require("./constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RolesEmptyPrompt = ({
  onEnable,
  docsLink,
  productName
}) => {
  const {
    security
  } = (0, _kea.useValues)(_kibana_logic.KibanaLogic);
  const [currentUser, setCurrentUser] = (0, _react.useState)(null);
  const isSuperUser = currentUser === null || currentUser === void 0 ? void 0 : currentUser.roles.includes('superuser');
  const rbacDisabledLabel = !isSuperUser && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "xs",
    "data-test-subj": "rbacDisabledLabel"
  }, _constants.RBAC_BUTTON_DISABLED_LABEL);
  (0, _react.useEffect)(() => {
    security.authc.getCurrentUser().then(setCurrentUser).catch(() => {
      setCurrentUser(null);
    });
  }, [security.authc]);
  if (!currentUser) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "lockOpen",
    title: /*#__PURE__*/_react.default.createElement("h2", null, _constants.ROLES_DISABLED_TITLE),
    body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, (0, _constants.ROLES_DISABLED_DESCRIPTION)(productName)), /*#__PURE__*/_react.default.createElement("p", null, _constants.ROLES_DISABLED_NOTE)),
    actions: [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      disabled: !isSuperUser,
      key: "enableRolesButton",
      fill: true,
      onClick: onEnable
    }, _constants.ENABLE_ROLES_BUTTON), rbacDisabledLabel, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      key: "spacer",
      size: "xs"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      key: "enableRolesLink",
      href: docsLink,
      target: "_blank",
      external: true
    }, _constants.ENABLE_ROLES_LINK)]
  });
};
exports.RolesEmptyPrompt = RolesEmptyPrompt;