"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Toasts = exports.FlashMessages = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _constants = require("./constants");
var _flash_messages_logic = require("./flash_messages_logic");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FlashMessages = ({
  children
}) => {
  const {
    messages
  } = (0, _kea.useValues)(_flash_messages_logic.FlashMessagesLogic);
  return /*#__PURE__*/_react.default.createElement("div", {
    "aria-live": "polite",
    "data-test-subj": "FlashMessages"
  }, messages.map(({
    type,
    message,
    description,
    iconType
  }, index) => /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    key: index
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: _constants.FLASH_MESSAGE_TYPES[type].color,
    iconType: iconType !== null && iconType !== void 0 ? iconType : _constants.FLASH_MESSAGE_TYPES[type].iconType,
    title: message
  }, description), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null))), children);
};

/*
 * NOTE: Toasts are rendered at the highest app level (@see public/applications/index.tsx)
 * so that they don't rerender/reset their timers when navigating between pages,
 * and also to prevent z-index issues with flyouts and modals
 */
exports.FlashMessages = FlashMessages;
const Toasts = () => {
  const {
    toastMessages
  } = (0, _kea.useValues)(_flash_messages_logic.FlashMessagesLogic);
  const {
    dismissToastMessage
  } = (0, _kea.useActions)(_flash_messages_logic.FlashMessagesLogic);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiGlobalToastList, {
    toasts: toastMessages,
    dismissToast: dismissToastMessage,
    toastLifeTimeMs: _constants.DEFAULT_TOAST_TIMEOUT
  });
};
exports.Toasts = Toasts;