"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EnterpriseSearchContentConfigured = exports.EnterpriseSearchContent = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _kea = require("kea");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _is_version_mismatch = require("../../../common/is_version_mismatch");
var _setup_guide = require("../enterprise_search_overview/components/setup_guide");
var _error_state = require("../shared/error_state");
var _http = require("../shared/http");
var _kibana = require("../shared/kibana");
var _version_mismatch = require("../shared/version_mismatch");
var _connectors = require("./components/connectors/connectors");
var _not_found = require("./components/not_found");
var _search_indices = require("./components/search_indices");
var _settings = require("./components/settings");
var _routes = require("./routes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EnterpriseSearchContent = props => {
  const {
    config
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const {
    errorConnectingMessage
  } = (0, _kea.useValues)(_http.HttpLogic);
  const {
    enterpriseSearchVersion,
    kibanaVersion
  } = props;
  const incompatibleVersions = (0, _is_version_mismatch.isVersionMismatch)(enterpriseSearchVersion, kibanaVersion);
  const showView = () => {
    if (config.host && config.canDeployEntSearch && incompatibleVersions) {
      return /*#__PURE__*/_react.default.createElement(_version_mismatch.VersionMismatchPage, {
        enterpriseSearchVersion: enterpriseSearchVersion,
        kibanaVersion: kibanaVersion
      });
    }
    return /*#__PURE__*/_react.default.createElement(EnterpriseSearchContentConfigured, props);
  };
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: _routes.SETUP_GUIDE_PATH
  }, /*#__PURE__*/_react.default.createElement(_setup_guide.SetupGuide, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: _routes.ERROR_STATE_PATH
  }, config.host && config.canDeployEntSearch && errorConnectingMessage ? /*#__PURE__*/_react.default.createElement(_error_state.ErrorStatePrompt, null) : /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    to: _routes.SEARCH_INDICES_PATH
  })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, null, showView()));
};
exports.EnterpriseSearchContent = EnterpriseSearchContent;
const EnterpriseSearchContentConfigured = () => {
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    exact: true,
    from: _routes.ROOT_PATH,
    to: _routes.SEARCH_INDICES_PATH
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _routes.SEARCH_INDICES_PATH
  }, /*#__PURE__*/_react.default.createElement(_search_indices.SearchIndicesRouter, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _routes.CONNECTORS_PATH
  }, /*#__PURE__*/_react.default.createElement(_connectors.Connectors, {
    isCrawler: false
  })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _routes.CRAWLERS_PATH
  }, /*#__PURE__*/_react.default.createElement(_connectors.Connectors, {
    isCrawler: true
  })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _routes.SETTINGS_PATH
  }, /*#__PURE__*/_react.default.createElement(_settings.Settings, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, null, /*#__PURE__*/_react.default.createElement(_not_found.NotFound, null)));
};
exports.EnterpriseSearchContentConfigured = EnterpriseSearchContentConfigured;