"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MlInferencePipelineProcessorsCard = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _kibana_logic = require("../../../../shared/kibana/kibana_logic");
var _licensing = require("../../../../shared/licensing");
var _index_name_logic = require("../index_name_logic");
var _inference_pipeline_card = require("./inference_pipeline_card");
var _add_ml_inference_button = require("./ml_inference/add_ml_inference_button");
var _text_expansion_callout = require("./ml_inference/text_expansion_callout/text_expansion_callout");
var _pipelines_logic = require("./pipelines_logic");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MlInferencePipelineProcessorsCard = () => {
  var _capabilities$ml$canG, _capabilities$ml, _inferencePipelines$m;
  const {
    capabilities,
    isCloud
  } = (0, _kea.useValues)(_kibana_logic.KibanaLogic);
  const {
    hasPlatinumLicense
  } = (0, _kea.useValues)(_licensing.LicensingLogic);
  const {
    indexName
  } = (0, _kea.useValues)(_index_name_logic.IndexNameLogic);
  const {
    mlInferencePipelineProcessors: inferencePipelines
  } = (0, _kea.useValues)(_pipelines_logic.PipelinesLogic);
  const {
    fetchMlInferenceProcessors,
    openAddMlInferencePipelineModal
  } = (0, _kea.useActions)(_pipelines_logic.PipelinesLogic);
  (0, _react.useEffect)(() => {
    fetchMlInferenceProcessors({
      indexName
    });
  }, [indexName]);
  const hasMLPermissions = (_capabilities$ml$canG = capabilities === null || capabilities === void 0 ? void 0 : (_capabilities$ml = capabilities.ml) === null || _capabilities$ml === void 0 ? void 0 : _capabilities$ml.canGetTrainedModels) !== null && _capabilities$ml$canG !== void 0 ? _capabilities$ml$canG : false;
  const isGated = !isCloud && !hasPlatinumLicense;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, hasMLPermissions && !isGated && /*#__PURE__*/_react.default.createElement(_text_expansion_callout.TextExpansionCallOut, {
    isDismissable: true
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_add_ml_inference_button.AddMLInferencePipelineButton, {
    onClick: () => openAddMlInferencePipelineModal()
  })), (_inferencePipelines$m = inferencePipelines === null || inferencePipelines === void 0 ? void 0 : inferencePipelines.map((item, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: `${index}-${item.pipelineName}`
  }, /*#__PURE__*/_react.default.createElement(_inference_pipeline_card.InferencePipelineCard, item)))) !== null && _inferencePipelines$m !== void 0 ? _inferencePipelines$m : null);
};
exports.MlInferencePipelineProcessorsCard = MlInferencePipelineProcessorsCard;