"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OverviewLogic = void 0;
var _kea = require("kea");
var _constants = require("../../../../../common/constants");
var _api = require("../../../../../common/types/api");
var _kibana = require("../../../shared/kibana");
var _generate_api_key_logic = require("../../api/generate_api_key/generate_api_key_logic");
var _cached_fetch_index_api_logic = require("../../api/index/cached_fetch_index_api_logic");
var _fetch_index_pipeline_parameters = require("../../api/pipelines/fetch_index_pipeline_parameters");
var _routes = require("../../routes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OverviewLogic = (0, _kea.kea)({
  actions: {
    closeGenerateModal: true,
    openGenerateModal: true,
    toggleClientsPopover: true,
    toggleManageApiKeyPopover: true
  },
  connect: {
    actions: [_cached_fetch_index_api_logic.CachedFetchIndexApiLogic, ['apiError'], _generate_api_key_logic.GenerateApiKeyLogic, ['apiReset'], _fetch_index_pipeline_parameters.FetchIndexPipelineParametersApiLogic, ['makeRequest as fetchIndexPipelineParameters']],
    values: [_cached_fetch_index_api_logic.CachedFetchIndexApiLogic, ['indexData', 'status'], _generate_api_key_logic.GenerateApiKeyLogic, ['data as apiKeyData', 'status as apiKeyStatus'], _fetch_index_pipeline_parameters.FetchIndexPipelineParametersApiLogic, ['data as indexPipelineData']]
  },
  listeners: ({
    actions
  }) => ({
    apiError: async (_, breakpoint) => {
      // show error for a second before navigating away
      await breakpoint(1000);
      _kibana.KibanaLogic.values.navigateToUrl(_routes.SEARCH_INDICES_PATH);
    },
    openGenerateModal: () => {
      actions.apiReset();
    }
  }),
  path: ['enterprise_search', 'search_index', 'overview'],
  reducers: () => ({
    isClientsPopoverOpen: [false, {
      toggleClientsPopover: state => !state
    }],
    isGenerateModalOpen: [false, {
      closeGenerateModal: () => false,
      openGenerateModal: () => true
    }],
    isManageKeysPopoverOpen: [false, {
      openGenerateModal: () => false,
      toggleManageApiKeyPopover: state => !state
    }]
  }),
  selectors: ({
    selectors
  }) => ({
    apiKey: [() => [selectors.apiKeyStatus, selectors.apiKeyData], (apiKeyStatus, apiKeyData) => apiKeyStatus === _api.Status.SUCCESS ? apiKeyData.apiKey.encoded : ''],
    indexPipelineParameters: [() => [selectors.indexPipelineData], indexPipelineData => indexPipelineData !== null && indexPipelineData !== void 0 ? indexPipelineData : _constants.DEFAULT_PIPELINE_VALUES],
    isError: [() => [selectors.status], status => status === _api.Status.ERROR],
    isLoading: [() => [selectors.status, selectors.indexData], (status, data) => status === _api.Status.IDLE || typeof data === 'undefined' && status === _api.Status.LOADING]
  })
});
exports.OverviewLogic = OverviewLogic;