"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DomainManagementLogic = void 0;
var _kea = require("kea");
var _api = require("../../../../../../../common/types/api");
var _constants = require("../../../../../shared/constants");
var _table_pagination = require("../../../../../shared/table_pagination");
var _delete_crawler_domain_api_logic = require("../../../../api/crawler/delete_crawler_domain_api_logic");
var _get_crawler_domains_api_logic = require("../../../../api/crawler/get_crawler_domains_api_logic");
var _index_name_logic = require("../../index_name_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DomainManagementLogic = (0, _kea.kea)({
  connect: {
    actions: [_get_crawler_domains_api_logic.GetCrawlerDomainsApiLogic, ['apiSuccess as getApiSuccess'], _delete_crawler_domain_api_logic.DeleteCrawlerDomainApiLogic, ['apiSuccess as deleteApiSuccess']],
    values: [_get_crawler_domains_api_logic.GetCrawlerDomainsApiLogic, ['status as getStatus', 'data as getData'], _delete_crawler_domain_api_logic.DeleteCrawlerDomainApiLogic, ['status as deleteStatus'], _index_name_logic.IndexNameLogic, ['indexName']]
  },
  path: ['enterprise_search', 'domain_management'],
  actions: {
    deleteDomain: domain => ({
      domain
    }),
    getDomains: meta => ({
      meta
    }),
    onPaginate: newPageIndex => ({
      newPageIndex
    })
  },
  listeners: ({
    values,
    actions
  }) => ({
    deleteApiSuccess: () => {
      actions.getDomains(values.meta);
    },
    deleteDomain: ({
      domain
    }) => {
      const {
        indexName
      } = values;
      _delete_crawler_domain_api_logic.DeleteCrawlerDomainApiLogic.actions.makeRequest({
        domain,
        indexName
      });
    },
    getDomains: ({
      meta
    }) => {
      const {
        indexName
      } = values;
      _get_crawler_domains_api_logic.GetCrawlerDomainsApiLogic.actions.makeRequest({
        indexName,
        meta
      });
    },
    onPaginate: ({
      newPageIndex
    }) => {
      actions.getDomains((0, _table_pagination.updateMetaPageIndex)(values.meta, newPageIndex));
    }
  }),
  selectors: ({
    selectors
  }) => ({
    domains: [() => [selectors.getData], getData => {
      var _getData$domains;
      return (_getData$domains = getData === null || getData === void 0 ? void 0 : getData.domains) !== null && _getData$domains !== void 0 ? _getData$domains : [];
    }],
    meta: [() => [selectors.getData], getData => {
      var _getData$meta;
      return (_getData$meta = getData === null || getData === void 0 ? void 0 : getData.meta) !== null && _getData$meta !== void 0 ? _getData$meta : _constants.DEFAULT_META;
    }],
    isLoading: [() => [selectors.getStatus, selectors.deleteStatus], (getStatus, deleteStatus) => getStatus === _api.Status.IDLE || getStatus === _api.Status.LOADING || deleteStatus === _api.Status.LOADING]
  })
});
exports.DomainManagementLogic = DomainManagementLogic;