"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CrawlerDomainDetail = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _encode_path_params = require("../../../../../shared/encode_path_params");
var _loading = require("../../../../../shared/loading");
var _react_router_helpers = require("../../../../../shared/react_router_helpers");
var _routes = require("../../../../routes");
var _index_name_logic = require("../../index_name_logic");
var _search_index = require("../../search_index");
var _crawl_custom_settings_flyout = require("../crawl_custom_settings_flyout/crawl_custom_settings_flyout");
var _delete_domain_modal = require("../domain_management/delete_domain_modal");
var _delete_domain_modal_logic = require("../domain_management/delete_domain_modal_logic");
var _crawler_domain_detail_logic = require("./crawler_domain_detail_logic");
var _crawler_domain_detail_tabs = require("./crawler_domain_detail_tabs");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CrawlerDomainDetail = ({
  domainId
}) => {
  var _domain$url;
  const {
    indexName
  } = (0, _kea.useValues)(_index_name_logic.IndexNameLogic);
  const crawlerDomainDetailLogic = (0, _crawler_domain_detail_logic.CrawlerDomainDetailLogic)({
    domainId
  });
  const {
    domain,
    getLoading
  } = (0, _kea.useValues)(crawlerDomainDetailLogic);
  const {
    fetchDomainData
  } = (0, _kea.useActions)(crawlerDomainDetailLogic);
  const {
    showModal
  } = (0, _kea.useActions)(_delete_domain_modal_logic.DeleteDomainModalLogic);
  (0, _react.useEffect)(() => {
    fetchDomainData(domainId);
  }, [domainId]);
  const domainUrl = (_domain$url = domain === null || domain === void 0 ? void 0 : domain.url) !== null && _domain$url !== void 0 ? _domain$url : '...';
  return getLoading ? /*#__PURE__*/_react.default.createElement(_loading.Loading, null) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiButtonTo, {
    "data-telemetry-id": "entSearchContent-crawler-domainDetail-header-allDomains",
    color: "text",
    iconType: "arrowLeft",
    size: "s",
    to: (0, _encode_path_params.generateEncodedPath)(_routes.SEARCH_INDEX_TAB_PATH, {
      indexName,
      tabId: _search_index.SearchIndexTabId.DOMAIN_MANAGEMENT
    })
  }, _i18n.i18n.translate('xpack.enterpriseSearch.crawler.domainDetail.allDomainsButtonLabel', {
    defaultMessage: 'All domains'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Outer, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h4", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.crawler.domainDetail.title', {
    defaultMessage: 'Manage {domain}',
    values: {
      domain: domainUrl
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-telemetry-id": "entSearchContent-crawler-domainDetail-header-deleteDomain",
    isLoading: getLoading,
    color: "danger",
    onClick: () => {
      if (domain) {
        showModal(domain);
      }
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.crawler.domainDetail.deleteDomainButtonLabel', {
    defaultMessage: 'Delete domain'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, null, domain && /*#__PURE__*/_react.default.createElement(_crawler_domain_detail_tabs.CrawlerDomainDetailTabs, {
    domain: domain,
    indexName: indexName
  }), /*#__PURE__*/_react.default.createElement(_delete_domain_modal.DeleteDomainModal, null), /*#__PURE__*/_react.default.createElement(_crawl_custom_settings_flyout.CrawlCustomSettingsFlyout, null))));
};
exports.CrawlerDomainDetail = CrawlerDomainDetail;