"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchEnginesPopoverLogic = void 0;
var _kea = require("kea");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SearchEnginesPopoverLogic = (0, _kea.kea)({
  actions: {
    toggleSearchEnginesPopover: true
  },
  path: ['enterprise_search', 'search_index', 'header'],
  reducers: () => ({
    isSearchEnginesPopoverOpen: [false, {
      toggleSearchEnginesPopover: state => !state
    }]
  })
});
exports.SearchEnginesPopoverLogic = SearchEnginesPopoverLogic;