"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TrainedModelsApiLogic = void 0;
var _kea = require("kea");
var _api = require("../../../../../common/types/api");
var _ml_model_stats_logic = require("./ml_model_stats_logic");
var _ml_models_logic = require("./ml_models_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TrainedModelsApiLogic = (0, _kea.kea)({
  actions: {
    apiError: error => error,
    apiReset: true,
    apiSuccess: result => result,
    makeRequest: () => undefined
  },
  connect: {
    actions: [_ml_models_logic.MLModelsApiLogic, ['apiError as getModelsApiError', 'apiReset as getModelsApiReset', 'apiSuccess as getModelsApiSuccess', 'makeRequest as makeGetModelsRequest'], _ml_model_stats_logic.MLModelsStatsApiLogic, ['apiError as getModelsStatsApiError', 'apiReset as getModelsStatsApiReset', 'apiSuccess as getModelsStatsApiSuccess', 'makeRequest as makeGetModelsStatsRequest']],
    values: [_ml_models_logic.MLModelsApiLogic, ['apiStatus as modelsApiStatus', 'error as modelsApiError', 'status as modelsStatus', 'data as modelsData'], _ml_model_stats_logic.MLModelsStatsApiLogic, ['apiStatus as modelStatsApiStatus', 'error as modelsStatsApiError', 'status as modelStatsStatus', 'data as modelStatsData']]
  },
  listeners: ({
    actions,
    values
  }) => ({
    getModelsApiError: error => {
      actions.apiError(error);
    },
    getModelsApiSuccess: () => {
      if (!values.data) return;
      actions.apiSuccess(values.data);
    },
    getModelsStatsApiError: error => {
      if (values.modelsApiError) return;
      actions.apiError(error);
    },
    getModelsStatsApiSuccess: () => {
      if (!values.data) return;
      actions.apiSuccess(values.data);
    },
    apiReset: () => {
      actions.getModelsApiReset();
      actions.getModelsStatsApiReset();
    },
    makeRequest: () => {
      actions.makeGetModelsRequest(undefined);
      actions.makeGetModelsStatsRequest(undefined);
    }
  }),
  path: ['enterprise_search', 'api', 'ml_trained_models_api_logic'],
  selectors: ({
    selectors
  }) => ({
    data: [() => [selectors.modelsData, selectors.modelStatsData], (modelsData, modelStatsData) => {
      if (!modelsData) return null;
      if (!modelStatsData) return modelsData;
      const statsMap = modelStatsData.trained_model_stats.reduce((map, value) => {
        if (value.model_id) {
          map[value.model_id] = value;
        }
        return map;
      }, {});
      return modelsData.map(modelConfig => {
        const modelStats = statsMap[modelConfig.model_id];
        return {
          ...modelConfig,
          ...(modelStats !== null && modelStats !== void 0 ? modelStats : {})
        };
      });
    }],
    error: [() => [selectors.modelsApiStatus, selectors.modelStatsApiStatus], (modelsApiStatus, modelStatsApiStatus) => {
      if (modelsApiStatus.error) return modelsApiStatus.error;
      if (modelStatsApiStatus.error) return modelStatsApiStatus.error;
      return null;
    }],
    status: [() => [selectors.modelsApiStatus, selectors.modelStatsApiStatus], (modelsApiStatus, modelStatsApiStatus) => {
      if (modelsApiStatus.status === modelStatsApiStatus.status) return modelsApiStatus.status;
      if (modelsApiStatus.status === _api.Status.ERROR || modelStatsApiStatus.status === _api.Status.ERROR) return _api.Status.ERROR;
      if (modelsApiStatus.status < modelStatsApiStatus.status) return modelsApiStatus.status;
      return modelStatsApiStatus.status;
    }]
  })
});
exports.TrainedModelsApiLogic = TrainedModelsApiLogic;