"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchSyncJobs = exports.FetchSyncJobsApiLogic = void 0;
var _create_api_logic = require("../../../shared/api_logic/create_api_logic");
var _http = require("../../../shared/http");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fetchSyncJobs = async ({
  connectorId,
  from = 0,
  size = 10,
  type
}) => {
  const route = `/internal/enterprise_search/connectors/${connectorId}/sync_jobs`;
  const query = {
    from,
    size,
    type
  };
  return await _http.HttpLogic.values.http.get(route, {
    query
  });
};
exports.fetchSyncJobs = fetchSyncJobs;
const FetchSyncJobsApiLogic = (0, _create_api_logic.createApiLogic)(['enterprise_search_content', 'fetch_sync_api_logic'], fetchSyncJobs);
exports.FetchSyncJobsApiLogic = FetchSyncJobsApiLogic;