"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResultFieldValue = void 0;
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _types = require("../../../shared/schema/types");
require("./result_field_value.scss");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isNotNumeric = raw => {
  if (typeof raw === 'number') return false;
  return isNaN(parseFloat(raw));
};
const isScalarValue = (_, type) => {
  return type !== _types.SchemaType.Nested;
};
const getRawDisplay = (raw, type) => {
  if (!raw) {
    return null;
  }
  if (!isScalarValue(raw, type)) {
    return JSON.stringify(raw);
  }
  if (Array.isArray(raw)) {
    return getRawArrayDisplay(raw);
  }
  return raw.toString();
};
const getRawArrayDisplay = rawArray => {
  return `[${rawArray.map(raw => isNotNumeric(raw) ? `"${raw}"` : raw).join(', ')}]`;
};
const parseHighlights = highlight => {
  return highlight.replace(/<em>(.+?)<\/em>/gi, '<mark class="euiMark">$1</mark>');
};
const isFieldValueEmpty = (type, raw, snippet) => {
  const isNumber = type === 'number';
  if (isNumber) {
    return raw === null;
  }
  return !snippet && !raw;
};
const ResultFieldValue = ({
  snippet,
  raw,
  type,
  className
}) => {
  const isEmpty = isFieldValueEmpty(type, raw, snippet);
  if (isEmpty) return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, "\u2014");
  const classes = (0, _classnames.default)({
    [`enterpriseSearchDataType--${type}`]: !!type
  }, className);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: classes
    /*
     * Justification for dangerouslySetInnerHTML:
     * The App Search server will return html highlights within fields. This data is sanitized by
     * the App Search server is considered safe for use.
     */,
    dangerouslySetInnerHTML: snippet ? {
      __html: parseHighlights(snippet)
    } : undefined // eslint-disable-line react/no-danger
  }, !!snippet ? null : getRawDisplay(raw, type));
};
exports.ResultFieldValue = ResultFieldValue;