"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProximityBoostFunction = exports.FunctionalBoostFunction = exports.BoostType = exports.BoostOperation = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let BoostType;
exports.BoostType = BoostType;
(function (BoostType) {
  BoostType["Value"] = "value";
  BoostType["Functional"] = "functional";
  BoostType["Proximity"] = "proximity";
})(BoostType || (exports.BoostType = BoostType = {}));
let FunctionalBoostFunction;
exports.FunctionalBoostFunction = FunctionalBoostFunction;
(function (FunctionalBoostFunction) {
  FunctionalBoostFunction["Logarithmic"] = "logarithmic";
  FunctionalBoostFunction["Exponential"] = "exponential";
  FunctionalBoostFunction["Linear"] = "linear";
})(FunctionalBoostFunction || (exports.FunctionalBoostFunction = FunctionalBoostFunction = {}));
let ProximityBoostFunction;
exports.ProximityBoostFunction = ProximityBoostFunction;
(function (ProximityBoostFunction) {
  ProximityBoostFunction["Gaussian"] = "gaussian";
  ProximityBoostFunction["Exponential"] = "exponential";
  ProximityBoostFunction["Linear"] = "linear";
})(ProximityBoostFunction || (exports.ProximityBoostFunction = ProximityBoostFunction = {}));
let BoostOperation;
exports.BoostOperation = BoostOperation;
(function (BoostOperation) {
  BoostOperation["Add"] = "add";
  BoostOperation["Multiply"] = "multiply";
})(BoostOperation || (exports.BoostOperation = BoostOperation = {})); // A boost that comes from the server, before we normalize it has a much looser schema