"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SANITIZED_NAME_NOTE = exports.META_ENGINE_CREATION_TITLE = exports.META_ENGINE_CREATION_SUCCESS_MESSAGE = exports.META_ENGINE_CREATION_FORM_TITLE = exports.META_ENGINE_CREATION_FORM_SUBMIT_BUTTON_LABEL = exports.META_ENGINE_CREATION_FORM_META_ENGINE_DESCRIPTION = exports.META_ENGINE_CREATION_FORM_MAX_SOURCE_ENGINES_WARNING_TITLE = exports.META_ENGINE_CREATION_FORM_ENGINE_SOURCE_ENGINES_LABEL = exports.META_ENGINE_CREATION_FORM_ENGINE_NAME_PLACEHOLDER = exports.META_ENGINE_CREATION_FORM_ENGINE_NAME_LABEL = exports.META_ENGINE_CREATION_FORM_DOCUMENTATION_LINK = exports.META_ENGINE_CREATION_FORM_DOCUMENTATION_DESCRIPTION = exports.DEFAULT_LANGUAGE = exports.ALLOWED_CHARS_NOTE = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _routes = require("../../routes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_LANGUAGE = 'Universal';
exports.DEFAULT_LANGUAGE = DEFAULT_LANGUAGE;
const META_ENGINE_CREATION_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.metaEngineCreation.title', {
  defaultMessage: 'Create a meta engine'
});
exports.META_ENGINE_CREATION_TITLE = META_ENGINE_CREATION_TITLE;
const META_ENGINE_CREATION_FORM_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.metaEngineCreation.form.title', {
  defaultMessage: 'Name your meta engine'
});
exports.META_ENGINE_CREATION_FORM_TITLE = META_ENGINE_CREATION_FORM_TITLE;
const META_ENGINE_CREATION_FORM_SUBMIT_BUTTON_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.metaEngineCreation.form.submitButton.buttonLabel', {
  defaultMessage: 'Create meta engine'
});
exports.META_ENGINE_CREATION_FORM_SUBMIT_BUTTON_LABEL = META_ENGINE_CREATION_FORM_SUBMIT_BUTTON_LABEL;
const META_ENGINE_CREATION_FORM_META_ENGINE_DESCRIPTION = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.metaEngineCreation.form.metaEngineDescription', {
  defaultMessage: 'Meta engines allow you to combine multiple engines into one searchable engine.'
});
exports.META_ENGINE_CREATION_FORM_META_ENGINE_DESCRIPTION = META_ENGINE_CREATION_FORM_META_ENGINE_DESCRIPTION;
const META_ENGINE_CREATION_FORM_DOCUMENTATION_LINK = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.metaEngineCreation.form.documentationLink', {
  defaultMessage: 'Read the documentation'
});
exports.META_ENGINE_CREATION_FORM_DOCUMENTATION_LINK = META_ENGINE_CREATION_FORM_DOCUMENTATION_LINK;
const META_ENGINE_CREATION_FORM_DOCUMENTATION_DESCRIPTION = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.enterpriseSearch.appSearch.metaEngineCreation.form.documentationDescription",
  defaultMessage: "{documentationLink} for information about how to get started.",
  values: {
    documentationLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: _routes.META_ENGINES_DOCS_URL,
      target: "_blank"
    }, META_ENGINE_CREATION_FORM_DOCUMENTATION_LINK)
  }
});
exports.META_ENGINE_CREATION_FORM_DOCUMENTATION_DESCRIPTION = META_ENGINE_CREATION_FORM_DOCUMENTATION_DESCRIPTION;
const META_ENGINE_CREATION_FORM_ENGINE_NAME_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.metaEngineCreation.form.engineName.label', {
  defaultMessage: 'Meta engine name'
});
exports.META_ENGINE_CREATION_FORM_ENGINE_NAME_LABEL = META_ENGINE_CREATION_FORM_ENGINE_NAME_LABEL;
const ALLOWED_CHARS_NOTE = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.metaEngineCreation.form.engineName.allowedCharactersHelpText', {
  defaultMessage: 'Meta engine names can only contain lowercase letters, numbers, and hyphens'
});
exports.ALLOWED_CHARS_NOTE = ALLOWED_CHARS_NOTE;
const SANITIZED_NAME_NOTE = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.metaEngineCreation.form.engineName.sanitizedNameHelpText', {
  defaultMessage: 'Your meta engine will be named'
});
exports.SANITIZED_NAME_NOTE = SANITIZED_NAME_NOTE;
const META_ENGINE_CREATION_FORM_ENGINE_NAME_PLACEHOLDER = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.metaEngineCreation.form.engineName.placeholder', {
  defaultMessage: 'i.e., my-meta-engine'
});
exports.META_ENGINE_CREATION_FORM_ENGINE_NAME_PLACEHOLDER = META_ENGINE_CREATION_FORM_ENGINE_NAME_PLACEHOLDER;
const META_ENGINE_CREATION_FORM_ENGINE_SOURCE_ENGINES_LABEL = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.metaEngineCreation.form.sourceEngines.label', {
  defaultMessage: 'Add source engines to this meta engine'
});
exports.META_ENGINE_CREATION_FORM_ENGINE_SOURCE_ENGINES_LABEL = META_ENGINE_CREATION_FORM_ENGINE_SOURCE_ENGINES_LABEL;
const META_ENGINE_CREATION_FORM_MAX_SOURCE_ENGINES_WARNING_TITLE = maxEnginesPerMetaEngine => _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.metaEngineCreation.form.sourceEngines.maxSourceEnginesWarningTitle', {
  defaultMessage: 'Meta engines have a limit of {maxEnginesPerMetaEngine} source engines',
  values: {
    maxEnginesPerMetaEngine
  }
});
exports.META_ENGINE_CREATION_FORM_MAX_SOURCE_ENGINES_WARNING_TITLE = META_ENGINE_CREATION_FORM_MAX_SOURCE_ENGINES_WARNING_TITLE;
const META_ENGINE_CREATION_SUCCESS_MESSAGE = name => _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.metaEngineCreation.successMessage', {
  defaultMessage: "Meta engine '{name}' was created",
  values: {
    name
  }
});
exports.META_ENGINE_CREATION_SUCCESS_MESSAGE = META_ENGINE_CREATION_SUCCESS_MESSAGE;