"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NAME_COLUMN = exports.LAST_UPDATED_COLUMN = exports.FIELD_COUNT_COLUMN = exports.DOCUMENT_COUNT_COLUMN = exports.CREATED_AT_COLUMN = exports.BLANK_COLUMN = exports.ACTIONS_COLUMN = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _ = require("../..");
var _constants = require("../../../../../shared/constants");
var _formatted_date_time = require("../../../../utils/formatted_date_time");
var _engine_link_helpers = require("./engine_link_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BLANK_COLUMN = {
  render: () => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null),
  'aria-hidden': true
};
exports.BLANK_COLUMN = BLANK_COLUMN;
const NAME_COLUMN = {
  field: 'name',
  name: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.enginesOverview.table.column.name', {
    defaultMessage: 'Name'
  }),
  width: '30%',
  truncateText: true,
  mobileOptions: {
    header: true,
    enlarge: true,
    width: '100%'
  }
};
exports.NAME_COLUMN = NAME_COLUMN;
const CREATED_AT_COLUMN = {
  field: 'created_at',
  name: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.enginesOverview.table.column.createdAt', {
    defaultMessage: 'Created at'
  }),
  dataType: 'string',
  render: dateString => /*#__PURE__*/_react.default.createElement(_formatted_date_time.FormattedDateTime, {
    date: new Date(dateString),
    hideTime: true
  })
};
exports.CREATED_AT_COLUMN = CREATED_AT_COLUMN;
const LAST_UPDATED_COLUMN = {
  field: 'updated_at',
  name: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.enginesOverview.table.column.lastUpdated', {
    defaultMessage: 'Last updated'
  }),
  dataType: 'string'
};
exports.LAST_UPDATED_COLUMN = LAST_UPDATED_COLUMN;
const DOCUMENT_COUNT_COLUMN = {
  field: 'document_count',
  name: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.enginesOverview.table.column.documentCount', {
    defaultMessage: 'Document count'
  }),
  dataType: 'number',
  render: number => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedNumber, {
    value: number
  }),
  truncateText: true
};
exports.DOCUMENT_COUNT_COLUMN = DOCUMENT_COUNT_COLUMN;
const FIELD_COUNT_COLUMN = {
  field: 'field_count',
  name: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.enginesOverview.table.column.fieldCount', {
    defaultMessage: 'Field count'
  }),
  dataType: 'number',
  render: number => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedNumber, {
    value: number
  }),
  truncateText: true
};
exports.FIELD_COUNT_COLUMN = FIELD_COUNT_COLUMN;
const ACTIONS_COLUMN = {
  name: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.enginesOverview.table.column.actions', {
    defaultMessage: 'Actions'
  }),
  actions: [{
    name: _constants.MANAGE_BUTTON_LABEL,
    description: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.enginesOverview.table.action.manage.buttonDescription', {
      defaultMessage: 'Manage this engine'
    }),
    type: 'icon',
    icon: 'eye',
    onClick: engineDetails => (0, _engine_link_helpers.navigateToEngine)(engineDetails.name)
  }, {
    name: _constants.DELETE_BUTTON_LABEL,
    description: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.enginesOverview.table.action.delete.buttonDescription', {
      defaultMessage: 'Delete this engine'
    }),
    type: 'icon',
    icon: 'trash',
    color: 'danger',
    onClick: engine => {
      if (window.confirm(_i18n.i18n.translate('xpack.enterpriseSearch.appSearch.enginesOverview.table.action.delete.confirmationPopupMessage', {
        defaultMessage: 'Are you sure you want to permanently delete "{engineName}" and all of its content?',
        values: {
          engineName: engine.name
        }
      }))) {
        _.EnginesLogic.actions.deleteEngine(engine);
      }
    }
  }]
};
exports.ACTIONS_COLUMN = ACTIONS_COLUMN;