"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmptyState = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react_router_helpers = require("../../../../shared/react_router_helpers");
var _telemetry = require("../../../../shared/telemetry");
var _app_logic = require("../../../app_logic");
var _icons = require("../../../icons");
var _routes = require("../../../routes");
var _sample_engine_creation_cta = require("../../sample_engine_creation_cta/sample_engine_creation_cta");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EmptyState = () => {
  const {
    myRole: {
      canManageEngines
    }
  } = (0, _kea.useValues)(_app_logic.AppLogic);
  const {
    sendAppSearchTelemetry
  } = (0, _kea.useActions)(_telemetry.TelemetryLogic);
  return canManageEngines ? /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    "data-test-subj": "AdminEmptyEnginesPrompt",
    iconType: _icons.EngineIcon,
    title: /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.emptyState.title', {
      defaultMessage: 'Create your first engine'
    })),
    titleSize: "l",
    body: /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.emptyState.description1', {
      defaultMessage: 'An App Search engine stores the documents for your search experience.'
    })),
    actions: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiButtonTo, {
      "data-test-subj": "EmptyStateCreateFirstEngineCta",
      fill: true,
      to: _routes.ENGINE_CREATION_PATH,
      onClick: () => sendAppSearchTelemetry({
        action: 'clicked',
        metric: 'create_first_engine_button'
      })
    }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.emptyState.createFirstEngineCta', {
      defaultMessage: 'Create an engine'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xxl"
    }), /*#__PURE__*/_react.default.createElement(_sample_engine_creation_cta.SampleEngineCreationCta, null))
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    "data-test-subj": "NonAdminEmptyEnginesPrompt",
    iconType: _icons.EngineIcon,
    title: /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.emptyState.nonAdmin.title', {
      defaultMessage: 'No engines available'
    })),
    body: /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.emptyState.nonAdmin.description', {
      defaultMessage: 'Contact your App Search administrator to either create or grant you access to an engine.'
    }))
  });
};
exports.EmptyState = EmptyState;