"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnalyticsChart = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _moment = _interopRequireDefault(require("moment"));
var _charts = require("@elastic/charts");
var _i18n = require("@kbn/i18n");
var _kibana = require("../../../../shared/kibana");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AnalyticsChart = ({
  height = 300,
  lines
}) => {
  const {
    charts
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  return /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    size: {
      height
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Tooltip, {
    headerFormatter: tooltip => (0, _moment.default)(tooltip.value).format(_constants.TOOLTIP_DATE_FORMAT)
  }), /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    theme: charts.theme.useChartsTheme(),
    baseTheme: charts.theme.useChartsBaseTheme(),
    locale: _i18n.i18n.getLocale()
  }), lines.map(({
    id,
    data,
    isDashed
  }) => /*#__PURE__*/_react.default.createElement(_charts.LineSeries, {
    key: id,
    id: id,
    data: data,
    xAccessor: 'x',
    yAccessors: ['y'],
    curve: _charts.CurveType.CURVE_MONOTONE_X,
    lineSeriesStyle: isDashed ? {
      line: {
        dash: [5, 5]
      }
    } : undefined
  })), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "bottom-axis",
    position: "bottom",
    tickFormat: d => (0, _moment.default)(d).format(_constants.X_AXIS_DATE_FORMAT),
    gridLine: {
      visible: true
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "left-axis",
    position: "left",
    ticks: 4,
    gridLine: {
      visible: true
    }
  }));
};
exports.AnalyticsChart = AnalyticsChart;