"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findOrCreateDataView = void 0;
var _kibana_logic = require("../../shared/kibana/kibana_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const findOrCreateDataView = async collection => {
  const dataView = (await _kibana_logic.KibanaLogic.values.data.dataViews.find(collection.events_datastream, 1)).find(result => result.title === collection.events_datastream);
  if (dataView) {
    return dataView;
  }
  return await _kibana_logic.KibanaLogic.values.data.dataViews.createAndSave({
    allowNoIndex: true,
    name: `behavioral_analytics.events-${collection.name}`,
    timeFieldName: '@timestamp',
    title: collection.events_datastream
  }, true);
};
exports.findOrCreateDataView = findOrCreateDataView;