"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnalyticsCollectionViewMetricWithLens = exports.AnalyticsCollectionViewMetric = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _uiTheme = require("@kbn/ui-theme");
var _with_lens_data = require("../../../hoc/with_lens_data");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
var MetricStatus;
(function (MetricStatus) {
  MetricStatus["INCREASE"] = "increase";
  MetricStatus["DECREASE"] = "decrease";
  MetricStatus["CONSTANT"] = "constant";
})(MetricStatus || (MetricStatus = {}));
const getMetricTheme = (euiTheme, status) => ({
  [MetricStatus.DECREASE]: {
    color: _uiTheme.euiThemeVars.euiColorVis7,
    icon: 'sortDown'
  },
  [MetricStatus.CONSTANT]: {
    color: euiTheme.colors.darkShade,
    icon: 'minus'
  },
  [MetricStatus.INCREASE]: {
    color: _uiTheme.euiThemeVars.euiColorVis0,
    icon: 'sortUp'
  }
})[status];
const getMetricStatus = metric => {
  if (metric > 0) return MetricStatus.INCREASE;
  if (metric < 0) return MetricStatus.DECREASE;
  return MetricStatus.CONSTANT;
};
const AnalyticsCollectionViewMetric = ({
  isLoading,
  isSelected,
  metric,
  name,
  onClick,
  secondaryMetric
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [displayMetric, setDisplayMetric] = (0, _react.useState)(metric);
  const [displaySecondaryMetric, setDisplaySecondaryMetric] = (0, _react.useState)(secondaryMetric);
  (0, _react.useEffect)(() => {
    if (metric !== null) {
      setDisplayMetric(metric);
    }
  }, [metric]);
  (0, _react.useEffect)(() => {
    if (secondaryMetric !== null) {
      setDisplaySecondaryMetric(metric);
    }
  }, [secondaryMetric]);
  const {
    icon,
    color
  } = getMetricTheme(euiTheme, getMetricStatus(displaySecondaryMetric || 0));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    grow: true,
    hasBorder: true,
    hasShadow: false,
    onClick: onClick,
    color: isSelected ? 'primary' : 'plain',
    css: isSelected ? (0, _react2.css)`
              border: 1px solid ${euiTheme.colors.primary};
              position: relative;
              overflow: hidden;
            ` : (0, _react2.css)`
              position: relative;
              overflow: hidden;
            `
  }, isLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    color: "success",
    position: "absolute"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, name)), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: color
  }, /*#__PURE__*/_react.default.createElement("span", null, displaySecondaryMetric === null ? _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collection.notAvailableLabel', {
    defaultMessage: 'N/A'
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: icon
  }), displaySecondaryMetric + '%')))), isLoading && displayMetric === null ? /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonRectangle, {
    height: euiTheme.size.xl,
    width: "100%"
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: isSelected ? euiTheme.colors.primaryText : color
  }, /*#__PURE__*/_react.default.createElement("h2", null, displayMetric === null ? _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collection.notAvailableLabel', {
    defaultMessage: 'N/A'
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiI18nNumber, {
    value: displayMetric
  })))));
};
exports.AnalyticsCollectionViewMetric = AnalyticsCollectionViewMetric;
const LENS_LAYERS = {
  metrics: {
    hitsTotal: 'hitsTotal',
    id: 'metrics',
    percentage: 'percentage'
  }
};
const initialValues = {
  isLoading: true,
  metric: null,
  secondaryMetric: null
};
const AnalyticsCollectionViewMetricWithLens = (0, _with_lens_data.withLensData)(AnalyticsCollectionViewMetric, {
  dataLoadTransform: (isLoading, adapters) => {
    var _adapters$tables$tabl, _adapters$tables, _adapters$tables$tabl2, _adapters$tables$tabl3, _adapters$tables$tabl4, _adapters$tables$tabl5, _adapters$tables2, _adapters$tables2$tab, _adapters$tables2$tab2, _adapters$tables2$tab3;
    return isLoading || !adapters ? initialValues : {
      isLoading,
      metric: (_adapters$tables$tabl = (_adapters$tables = adapters.tables) === null || _adapters$tables === void 0 ? void 0 : (_adapters$tables$tabl2 = _adapters$tables.tables[LENS_LAYERS.metrics.id]) === null || _adapters$tables$tabl2 === void 0 ? void 0 : (_adapters$tables$tabl3 = _adapters$tables$tabl2.rows) === null || _adapters$tables$tabl3 === void 0 ? void 0 : (_adapters$tables$tabl4 = _adapters$tables$tabl3[0]) === null || _adapters$tables$tabl4 === void 0 ? void 0 : _adapters$tables$tabl4[LENS_LAYERS.metrics.hitsTotal]) !== null && _adapters$tables$tabl !== void 0 ? _adapters$tables$tabl : null,
      secondaryMetric: (_adapters$tables$tabl5 = (_adapters$tables2 = adapters.tables) === null || _adapters$tables2 === void 0 ? void 0 : (_adapters$tables2$tab = _adapters$tables2.tables[LENS_LAYERS.metrics.id]) === null || _adapters$tables2$tab === void 0 ? void 0 : (_adapters$tables2$tab2 = _adapters$tables2$tab.rows) === null || _adapters$tables2$tab2 === void 0 ? void 0 : (_adapters$tables2$tab3 = _adapters$tables2$tab2[0]) === null || _adapters$tables2$tab3 === void 0 ? void 0 : _adapters$tables2$tab3[LENS_LAYERS.metrics.percentage]) !== null && _adapters$tables$tabl5 !== void 0 ? _adapters$tables$tabl5 : null
    };
  },
  getAttributes: (dataView, formulaApi, props) => {
    let metric = formulaApi.insertOrReplaceFormulaColumn(LENS_LAYERS.metrics.percentage, {
      formula: `round((${props.getFormula()}/${props.getFormula('previous')}-1) * 100)`
    }, {
      columnOrder: [],
      columns: {}
    }, dataView);
    metric = formulaApi.insertOrReplaceFormulaColumn(LENS_LAYERS.metrics.hitsTotal, {
      formula: props.getFormula()
    }, metric, dataView);
    return {
      references: [{
        id: dataView.id,
        name: 'indexpattern-datasource-current-indexpattern',
        type: 'index-pattern'
      }, {
        id: dataView.id,
        name: `indexpattern-datasource-layer-${LENS_LAYERS.metrics.id}`,
        type: 'index-pattern'
      }],
      state: {
        datasourceStates: {
          formBased: {
            layers: {
              [LENS_LAYERS.metrics.id]: metric
            }
          }
        },
        filters: [],
        query: {
          language: 'kuery',
          query: ''
        },
        visualization: {
          layerId: [LENS_LAYERS.metrics.id],
          layerType: 'data',
          layers: [],
          metricAccessor: LENS_LAYERS.metrics.hitsTotal,
          secondaryMetricAccessor: LENS_LAYERS.metrics.percentage
        }
      },
      title: '',
      visualizationType: 'lnsMetric'
    };
  },
  initialValues
});
exports.AnalyticsCollectionViewMetricWithLens = AnalyticsCollectionViewMetricWithLens;