"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isEmbeddable = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const isEmbeddable = x => {
  if (!x) return false;
  if (typeof x !== 'object') return false;
  if (typeof x.id !== 'string') return false;
  if (typeof x.getInput !== 'function') return false;
  if (typeof x.supportedTriggers !== 'function') return false;
  return true;
};
exports.isEmbeddable = isEmbeddable;