"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEmbeddablePanelBadges = void 0;
var _uiTheme = require("@kbn/ui-theme");
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _ = require("../..");
var _kibana_services = require("../../kibana_services");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const useEmbeddablePanelBadges = (showNotifications, showBadges, embeddable, getActions) => {
  const getActionsForTrigger = getActions !== null && getActions !== void 0 ? getActions : _kibana_services.uiActions.getTriggerCompatibleActions;
  const [badges, setBadges] = (0, _react.useState)();
  const [notifications, setNotifications] = (0, _react.useState)();
  const getAllBadgesFromEmbeddable = (0, _react.useCallback)(async () => {
    var _ref;
    if (!showBadges) return;
    let currentBadges = (_ref = await getActionsForTrigger(_.PANEL_BADGE_TRIGGER, {
      embeddable
    })) !== null && _ref !== void 0 ? _ref : [];
    const {
      disabledActions
    } = embeddable.getInput();
    if (disabledActions) {
      currentBadges = currentBadges.filter(badge => disabledActions.indexOf(badge.id) === -1);
    }
    return currentBadges;
  }, [embeddable, getActionsForTrigger, showBadges]);
  const getAllNotificationsFromEmbeddable = (0, _react.useCallback)(async () => {
    var _ref2;
    if (!showNotifications) return;
    let currentNotifications = (_ref2 = await getActionsForTrigger(_.PANEL_NOTIFICATION_TRIGGER, {
      embeddable
    })) !== null && _ref2 !== void 0 ? _ref2 : [];
    const {
      disabledActions
    } = embeddable.getInput();
    if (disabledActions) {
      currentNotifications = currentNotifications.filter(badge => disabledActions.indexOf(badge.id) === -1);
    }
    return currentNotifications;
  }, [embeddable, getActionsForTrigger, showNotifications]);

  /**
   * On embeddable creation get initial badges & notifications then subscribe to all
   * input updates to refresh them
   */
  (0, _react.useEffect)(() => {
    let canceled = false;
    let subscription;
    const updateNotificationsAndBadges = async () => {
      const [newBadges, newNotifications] = await Promise.all([getAllBadgesFromEmbeddable(), getAllNotificationsFromEmbeddable()]);
      if (canceled) return;
      setBadges(newBadges);
      setNotifications(newNotifications);
    };
    updateNotificationsAndBadges().then(() => {
      if (canceled) return;

      /**
       * since any piece of state could theoretically change which actions are available we need to
       * recalculate them on any input change or any parent input change.
       */
      subscription = embeddable.getInput$().subscribe(() => updateNotificationsAndBadges());
      if (embeddable.parent) {
        subscription.add(embeddable.parent.getInput$().subscribe(() => updateNotificationsAndBadges()));
      }
    });
    return () => {
      var _subscription;
      (_subscription = subscription) === null || _subscription === void 0 ? void 0 : _subscription.unsubscribe();
      canceled = true;
    };
  }, [embeddable, getAllBadgesFromEmbeddable, getAllNotificationsFromEmbeddable]);
  const badgeComponents = (0, _react.useMemo)(() => badges === null || badges === void 0 ? void 0 : badges.map(badge => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    key: badge.id,
    className: "embPanel__headerBadge",
    iconType: badge.getIconType({
      embeddable,
      trigger: _.panelBadgeTrigger
    }),
    onClick: () => badge.execute({
      embeddable,
      trigger: _.panelBadgeTrigger
    }),
    onClickAriaLabel: badge.getDisplayName({
      embeddable,
      trigger: _.panelBadgeTrigger
    }),
    "data-test-subj": `embeddablePanelBadge-${badge.id}`
  }, badge.getDisplayName({
    embeddable,
    trigger: _.panelBadgeTrigger
  }))), [badges, embeddable]);
  const notificationComponents = (0, _react.useMemo)(() => notifications === null || notifications === void 0 ? void 0 : notifications.map(notification => {
    const context = {
      embeddable
    };
    let badge = notification.MenuItem ? /*#__PURE__*/_react.default.createElement(notification.MenuItem, {
      key: notification.id,
      context: {
        embeddable,
        trigger: _.panelNotificationTrigger
      }
    }) : /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
      "data-test-subj": `embeddablePanelNotification-${notification.id}`,
      key: notification.id,
      style: {
        marginTop: _uiTheme.euiThemeVars.euiSizeXS,
        marginRight: _uiTheme.euiThemeVars.euiSizeXS
      },
      onClick: () => notification.execute({
        ...context,
        trigger: _.panelNotificationTrigger
      })
    }, notification.getDisplayName({
      ...context,
      trigger: _.panelNotificationTrigger
    }));
    if (notification.getDisplayNameTooltip) {
      const tooltip = notification.getDisplayNameTooltip({
        ...context,
        trigger: _.panelNotificationTrigger
      });
      if (tooltip) {
        badge = /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
          position: "top",
          delay: "regular",
          content: tooltip,
          key: notification.id
        }, badge);
      }
    }
    return badge;
  }), [embeddable, notifications]);
  return {
    badgeComponents,
    notificationComponents
  };
};
exports.useEmbeddablePanelBadges = useEmbeddablePanelBadges;