"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditPanelAction = exports.ACTION_EDIT_PANEL = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _operators = require("rxjs/operators");
var _lib = require("../../../lib");
var _types = require("../../../lib/types");
var _errors = require("../../../lib/errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const ACTION_EDIT_PANEL = 'editPanel';
exports.ACTION_EDIT_PANEL = ACTION_EDIT_PANEL;
class EditPanelAction {
  constructor(getEmbeddableFactory, application, stateTransfer) {
    var _this$application;
    (0, _defineProperty2.default)(this, "type", ACTION_EDIT_PANEL);
    (0, _defineProperty2.default)(this, "id", ACTION_EDIT_PANEL);
    (0, _defineProperty2.default)(this, "order", 50);
    (0, _defineProperty2.default)(this, "currentAppId", void 0);
    this.getEmbeddableFactory = getEmbeddableFactory;
    this.application = application;
    this.stateTransfer = stateTransfer;
    if ((_this$application = this.application) !== null && _this$application !== void 0 && _this$application.currentAppId$) {
      this.application.currentAppId$.pipe((0, _operators.take)(1)).subscribe(appId => this.currentAppId = appId);
    }
  }
  getDisplayName({
    embeddable
  }) {
    const factory = this.getEmbeddableFactory(embeddable.type);
    if (!factory) {
      throw new _errors.EmbeddableFactoryNotFoundError(embeddable.type);
    }
    return _i18n.i18n.translate('embeddableApi.panel.editPanel.displayName', {
      defaultMessage: 'Edit {value}',
      values: {
        value: factory.getDisplayName()
      }
    });
  }
  getIconType() {
    return 'pencil';
  }
  async isCompatible({
    embeddable
  }) {
    const canEditEmbeddable = Boolean(embeddable && embeddable.getOutput().editable && !embeddable.getOutput().inlineEditable && (embeddable.getOutput().editUrl || embeddable.getOutput().editApp && embeddable.getOutput().editPath || embeddable.getOutput().editableWithExplicitInput));
    const inDashboardEditMode = embeddable.getInput().viewMode === _types.ViewMode.EDIT;
    return Boolean(canEditEmbeddable && inDashboardEditMode);
  }
  async execute(context) {
    const embeddable = context.embeddable;
    const {
      editableWithExplicitInput
    } = embeddable.getOutput();
    if (editableWithExplicitInput) {
      var _embeddable$parent;
      const factory = this.getEmbeddableFactory(embeddable.type);
      if (!factory) {
        throw new _errors.EmbeddableFactoryNotFoundError(embeddable.type);
      }
      const oldExplicitInput = embeddable.getExplicitInput();
      let newExplicitInput;
      try {
        const explicitInputReturn = await factory.getExplicitInput(oldExplicitInput, embeddable.parent);
        newExplicitInput = (0, _lib.isExplicitInputWithAttributes)(explicitInputReturn) ? explicitInputReturn.newInput : explicitInputReturn;
      } catch (e) {
        // error likely means user canceled editing
        return;
      }
      (_embeddable$parent = embeddable.parent) === null || _embeddable$parent === void 0 ? void 0 : _embeddable$parent.replaceEmbeddable(embeddable.id, newExplicitInput);
      return;
    }
    const appTarget = this.getAppTarget(context);
    if (appTarget) {
      if (this.stateTransfer && appTarget.state) {
        await this.stateTransfer.navigateToEditor(appTarget.app, {
          path: appTarget.path,
          state: appTarget.state
        });
      } else {
        await this.application.navigateToApp(appTarget.app, {
          path: appTarget.path
        });
      }
      return;
    }
    const href = await this.getHref(context);
    if (href) {
      window.location.href = href;
      return;
    }
  }
  getAppTarget({
    embeddable
  }) {
    const app = embeddable ? embeddable.getOutput().editApp : undefined;
    const path = embeddable ? embeddable.getOutput().editPath : undefined;
    if (app && path) {
      if (this.currentAppId) {
        var _embeddable$getAppCon, _embeddable$getAppCon2;
        const originatingPath = (_embeddable$getAppCon = embeddable.getAppContext()) === null || _embeddable$getAppCon === void 0 ? void 0 : (_embeddable$getAppCon2 = _embeddable$getAppCon.getCurrentPath) === null || _embeddable$getAppCon2 === void 0 ? void 0 : _embeddable$getAppCon2.call(_embeddable$getAppCon);
        const state = {
          originatingApp: this.currentAppId,
          valueInput: this.getExplicitInput({
            embeddable
          }),
          embeddableId: embeddable.id,
          searchSessionId: embeddable.getInput().searchSessionId,
          originatingPath
        };
        return {
          app,
          path,
          state
        };
      }
      return {
        app,
        path
      };
    }
  }
  async getHref({
    embeddable
  }) {
    const editUrl = embeddable ? embeddable.getOutput().editUrl : undefined;
    return editUrl ? editUrl : '';
  }
  getExplicitInput({
    embeddable
  }) {
    var _getInput$panels$embe, _embeddable$getRoot, _embeddable$getRoot$g, _embeddable$getRoot$g2, _embeddable$getRoot$g3;
    return (_getInput$panels$embe = (_embeddable$getRoot = embeddable.getRoot()) === null || _embeddable$getRoot === void 0 ? void 0 : (_embeddable$getRoot$g = _embeddable$getRoot.getInput()) === null || _embeddable$getRoot$g === void 0 ? void 0 : (_embeddable$getRoot$g2 = _embeddable$getRoot$g.panels) === null || _embeddable$getRoot$g2 === void 0 ? void 0 : (_embeddable$getRoot$g3 = _embeddable$getRoot$g2[embeddable.id]) === null || _embeddable$getRoot$g3 === void 0 ? void 0 : _embeddable$getRoot$g3.explicitInput) !== null && _getInput$panels$embe !== void 0 ? _getInput$panels$embe : embeddable.getInput();
  }
}
exports.EditPanelAction = EditPanelAction;