"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmbeddablePanel = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _panelLoader = require("@kbn/panel-loader");
var _use_embeddable_panel = require("./use_embeddable_panel");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Loads and renders an embeddable.
 */
const EmbeddablePanel = props => {
  const result = (0, _use_embeddable_panel.useEmbeddablePanel)({
    embeddable: props.embeddable
  });
  if (!result) return /*#__PURE__*/_react.default.createElement(_panelLoader.PanelLoader, {
    showShadow: props.showShadow,
    dataTestSubj: "embeddablePanelLoadingIndicator"
  });
  const {
    embeddable,
    ...passThroughProps
  } = props;
  return /*#__PURE__*/_react.default.createElement(result.Panel, (0, _extends2.default)({
    embeddable: result.unwrappedEmbeddable
  }, passThroughProps));
};
exports.EmbeddablePanel = EmbeddablePanel;