"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.bootstrap = void 0;
var _lib = require("./lib");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * This method initializes Embeddable plugin with initial set of
 * triggers and actions.
 */
const bootstrap = uiActions => {
  uiActions.registerTrigger(_lib.contextMenuTrigger);
  uiActions.registerTrigger(_lib.panelHoverTrigger);
  uiActions.registerTrigger(_lib.panelBadgeTrigger);
  uiActions.registerTrigger(_lib.panelNotificationTrigger);
  uiActions.registerTrigger(_lib.selectRangeTrigger);
  uiActions.registerTrigger(_lib.valueClickTrigger);
  uiActions.registerTrigger(_lib.multiValueClickTrigger);
  uiActions.registerTrigger(_lib.cellValueTrigger);
};
exports.bootstrap = bootstrap;