"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getKbResource = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * A knowledge base REST request
 */

/**
 * Returns the optional resource, e.g. `esql` from the request params, or undefined if it doesn't exist
 *
 * @param request A REST request
 *
 * @returns Returns the optional resource, e.g. `esql` from the request params, or undefined if it doesn't exist
 */
const getKbResource = request => {
  var _request$params;
  if ((request === null || request === void 0 ? void 0 : (_request$params = request.params) === null || _request$params === void 0 ? void 0 : _request$params.resource) != null) {
    return decodeURIComponent(request.params.resource);
  } else {
    return undefined;
  }
};
exports.getKbResource = getKbResource;