"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAlertCountsTool = exports.ALERT_COUNTS_TOOL_DESCRIPTION = void 0;
var _tools = require("langchain/tools");
var _get_alert_counts_query = require("./get_alert_counts_query");
var _helpers = require("../../helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ALERT_COUNTS_TOOL_DESCRIPTION = 'Call this for the counts of last 24 hours of open and acknowledged alerts in the environment, grouped by their severity and workflow status.';
exports.ALERT_COUNTS_TOOL_DESCRIPTION = ALERT_COUNTS_TOOL_DESCRIPTION;
const getAlertCountsTool = ({
  alertsIndexPattern,
  esClient,
  replacements,
  request
}) => {
  if (!(0, _helpers.requestHasRequiredAnonymizationParams)(request) || alertsIndexPattern == null) {
    return null;
  }
  return new _tools.DynamicTool({
    name: 'alert-counts',
    description: ALERT_COUNTS_TOOL_DESCRIPTION,
    func: async () => {
      const query = (0, _get_alert_counts_query.getAlertsCountQuery)(alertsIndexPattern);
      const result = await esClient.search(query);
      return JSON.stringify(result);
    },
    tags: ['alerts', 'alerts-count']
  });
};
exports.getAlertCountsTool = getAlertCountsTool;