"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.requestHasRequiredAnonymizationParams = exports.getMessageContentAndRole = exports.getLangChainMessages = exports.getLangChainMessage = void 0;
var _schema = require("langchain/schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getLangChainMessage = assistantMessage => {
  var _assistantMessage$con, _assistantMessage$con2, _assistantMessage$con3, _assistantMessage$con4;
  switch (assistantMessage.role) {
    case 'system':
      return new _schema.SystemMessage((_assistantMessage$con = assistantMessage.content) !== null && _assistantMessage$con !== void 0 ? _assistantMessage$con : '');
    case 'user':
      return new _schema.HumanMessage((_assistantMessage$con2 = assistantMessage.content) !== null && _assistantMessage$con2 !== void 0 ? _assistantMessage$con2 : '');
    case 'assistant':
      return new _schema.AIMessage((_assistantMessage$con3 = assistantMessage.content) !== null && _assistantMessage$con3 !== void 0 ? _assistantMessage$con3 : '');
    default:
      return new _schema.HumanMessage((_assistantMessage$con4 = assistantMessage.content) !== null && _assistantMessage$con4 !== void 0 ? _assistantMessage$con4 : '');
  }
};
exports.getLangChainMessage = getLangChainMessage;
const getLangChainMessages = assistantMessages => assistantMessages.map(getLangChainMessage);
exports.getLangChainMessages = getLangChainMessages;
const getMessageContentAndRole = prompt => ({
  content: prompt,
  role: 'user'
});
exports.getMessageContentAndRole = getMessageContentAndRole;
const requestHasRequiredAnonymizationParams = request => {
  var _request$body;
  const {
    allow,
    allowReplacement,
    replacements
  } = (_request$body = request === null || request === void 0 ? void 0 : request.body) !== null && _request$body !== void 0 ? _request$body : {};
  const allowIsValid = Array.isArray(allow) && allow.length > 0 &&
  // at least one field must be in the allow list
  allow.every(item => typeof item === 'string');
  const allowReplacementIsValid = Array.isArray(allowReplacement) && allowReplacement.every(item => typeof item === 'string');
  const replacementsIsValid = typeof replacements === 'object' && Object.keys(replacements).every(key => typeof replacements[key] === 'string');
  return allowIsValid && allowReplacementIsValid && replacementsIsValid;
};
exports.requestHasRequiredAnonymizationParams = requestHasRequiredAnonymizationParams;