"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SERVERLESS_TYPE = exports.RUM_AGENT_NAMES = exports.OPEN_TELEMETRY_AGENT_NAMES = exports.JAVA_AGENT_NAMES = exports.ELASTIC_AGENT_NAMES = exports.AGENT_NAMES = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * We cannot mark these arrays as const and derive their type
 * because we need to be able to assign them as mutable entities for ES queries.
 */

const ELASTIC_AGENT_NAMES = ['dotnet', 'go', 'iOS/swift', 'java', 'js-base', 'nodejs', 'php', 'python', 'ruby', 'rum-js', 'android/java'];
exports.ELASTIC_AGENT_NAMES = ELASTIC_AGENT_NAMES;
const OPEN_TELEMETRY_AGENT_NAMES = ['otlp', 'opentelemetry/cpp', 'opentelemetry/dotnet', 'opentelemetry/erlang', 'opentelemetry/go', 'opentelemetry/java', 'opentelemetry/nodejs', 'opentelemetry/php', 'opentelemetry/python', 'opentelemetry/ruby', 'opentelemetry/rust', 'opentelemetry/swift', 'opentelemetry/webjs'];
exports.OPEN_TELEMETRY_AGENT_NAMES = OPEN_TELEMETRY_AGENT_NAMES;
const JAVA_AGENT_NAMES = ['java', 'opentelemetry/java'];
exports.JAVA_AGENT_NAMES = JAVA_AGENT_NAMES;
const RUM_AGENT_NAMES = ['js-base', 'rum-js', 'opentelemetry/webjs'];
exports.RUM_AGENT_NAMES = RUM_AGENT_NAMES;
const SERVERLESS_TYPE = ['aws.lambda', 'azure.functions'];
exports.SERVERLESS_TYPE = SERVERLESS_TYPE;
const AGENT_NAMES = [...ELASTIC_AGENT_NAMES, ...OPEN_TELEMETRY_AGENT_NAMES, ...JAVA_AGENT_NAMES, ...RUM_AGENT_NAMES];
exports.AGENT_NAMES = AGENT_NAMES;