"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiscoverGridEmbeddable = DiscoverGridEmbeddable;
exports.DiscoverGridMemoized = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _discoverUtils = require("@kbn/discover-utils");
var _unifiedDataTable = require("@kbn/unified-data-table");
var _discover_grid = require("../components/discover_grid");
require("./saved_search_grid.scss");
var _discover_grid_flyout = require("../components/discover_grid_flyout");
var _saved_search_embeddable_base = require("./saved_search_embeddable_base");
var _render_custom_toolbar = require("../components/discover_grid/render_custom_toolbar");
var _total_documents = require("../application/main/components/total_documents/total_documents");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const DiscoverGridMemoized = /*#__PURE__*/_react.default.memo(_discover_grid.DiscoverGrid);
exports.DiscoverGridMemoized = DiscoverGridMemoized;
function DiscoverGridEmbeddable(props) {
  const {
    interceptedWarnings,
    ...gridProps
  } = props;
  const [expandedDoc, setExpandedDoc] = (0, _react.useState)(undefined);
  const renderDocumentView = (0, _react.useCallback)((hit, displayedRows, displayedColumns, customColumnTypes) => /*#__PURE__*/_react.default.createElement(_discover_grid_flyout.DiscoverGridFlyout, {
    dataView: props.dataView,
    hit: hit,
    hits: displayedRows
    // if default columns are used, dont make them part of the URL - the context state handling will take care to restore them
    ,
    columns: displayedColumns,
    columnTypes: customColumnTypes,
    savedSearchId: props.savedSearchId,
    onFilter: props.onFilter,
    onRemoveColumn: props.onRemoveColumn,
    onAddColumn: props.onAddColumn,
    onClose: () => setExpandedDoc(undefined),
    setExpandedDoc: setExpandedDoc,
    query: props.query
  }), [props.dataView, props.onAddColumn, props.onFilter, props.onRemoveColumn, props.query, props.savedSearchId]);
  const renderCustomToolbar = (0, _react.useMemo)(() => (0, _render_custom_toolbar.getRenderCustomToolbarWithElements)({
    leftSide: typeof props.totalHitCount === 'number' ? /*#__PURE__*/_react.default.createElement(_total_documents.TotalDocuments, {
      totalHitCount: props.totalHitCount
    }) : undefined
  }), [props.totalHitCount]);
  return /*#__PURE__*/_react.default.createElement(_saved_search_embeddable_base.SavedSearchEmbeddableBase, {
    totalHitCount: undefined // it will be rendered inside the custom grid toolbar instead
    ,
    isLoading: props.loadingState === _unifiedDataTable.DataLoadingState.loading,
    dataTestSubj: "embeddedSavedSearchDocTable",
    interceptedWarnings: props.interceptedWarnings
  }, /*#__PURE__*/_react.default.createElement(DiscoverGridMemoized, (0, _extends2.default)({}, gridProps, {
    totalHits: props.totalHitCount,
    setExpandedDoc: setExpandedDoc,
    expandedDoc: expandedDoc,
    configRowHeight: props.services.uiSettings.get(_discoverUtils.ROW_HEIGHT_OPTION),
    showMultiFields: props.services.uiSettings.get(_discoverUtils.SHOW_MULTIFIELDS),
    maxDocFieldsDisplayed: props.services.uiSettings.get(_discoverUtils.MAX_DOC_FIELDS_DISPLAYED),
    renderDocumentView: renderDocumentView,
    renderCustomToolbar: renderCustomToolbar
  })));
}