"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocumentViewModeToggle = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _discoverUtils = require("@kbn/discover-utils");
var _constants = require("../../../common/constants");
var _use_discover_services = require("../../hooks/use_discover_services");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const DocumentViewModeToggle = ({
  viewMode,
  setDiscoverViewMode
}) => {
  var _uiSettings$get;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    uiSettings
  } = (0, _use_discover_services.useDiscoverServices)();
  const isLegacy = (0, _react.useMemo)(() => uiSettings.get(_discoverUtils.DOC_TABLE_LEGACY), [uiSettings]);
  const includesNormalTabsStyle = viewMode === _constants.VIEW_MODE.AGGREGATED_LEVEL || isLegacy;
  const tabsPadding = includesNormalTabsStyle ? euiTheme.size.s : 0;
  const tabsCss = (0, _react2.css)`
    padding: ${tabsPadding} ${tabsPadding} 0 ${tabsPadding};

    .euiTab__content {
      line-height: ${euiTheme.size.xl};
    }
  `;
  const showViewModeToggle = (_uiSettings$get = uiSettings.get(_discoverUtils.SHOW_FIELD_STATISTICS)) !== null && _uiSettings$get !== void 0 ? _uiSettings$get : false;
  if (!showViewModeToggle) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    size: "m",
    css: tabsCss,
    "data-test-subj": "dscViewModeToggle",
    bottomBorder: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    isSelected: viewMode === _constants.VIEW_MODE.DOCUMENT_LEVEL,
    onClick: () => setDiscoverViewMode(_constants.VIEW_MODE.DOCUMENT_LEVEL),
    "data-test-subj": "dscViewModeDocumentButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.viewModes.document.label",
    defaultMessage: "Documents"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    isSelected: viewMode === _constants.VIEW_MODE.AGGREGATED_LEVEL,
    onClick: () => setDiscoverViewMode(_constants.VIEW_MODE.AGGREGATED_LEVEL),
    "data-test-subj": "dscViewModeFieldStatsButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.viewModes.fieldStatistics.label",
    defaultMessage: "Field statistics"
  })));
};
exports.DocumentViewModeToggle = DocumentViewModeToggle;