"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFlyoutActions = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_navigation_props = require("../../hooks/use_navigation_props");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const staticViewDocumentItem = {
  id: 'viewDocument',
  enabled: true,
  Content: () => /*#__PURE__*/_react.default.createElement(ViewDocument, null)
};
const useFlyoutActions = ({
  actions,
  ...props
}) => {
  var _actions$defaultActio, _actions$getActionIte, _actions$getActionIte2;
  const {
    dataView
  } = props;
  const {
    singleDocHref,
    contextViewHref,
    onOpenSingleDoc,
    onOpenContextView
  } = (0, _use_navigation_props.useNavigationProps)(props);
  const {
    viewSingleDocument = {
      disabled: false
    },
    viewSurroundingDocument = {
      disabled: false
    }
  } = (_actions$defaultActio = actions === null || actions === void 0 ? void 0 : actions.defaultActions) !== null && _actions$defaultActio !== void 0 ? _actions$defaultActio : {};
  const customActions = [...((_actions$getActionIte = actions === null || actions === void 0 ? void 0 : (_actions$getActionIte2 = actions.getActionItems) === null || _actions$getActionIte2 === void 0 ? void 0 : _actions$getActionIte2.call(actions)) !== null && _actions$getActionIte !== void 0 ? _actions$getActionIte : [])];
  const flyoutActions = [{
    id: 'singleDocument',
    enabled: !viewSingleDocument.disabled,
    Content: () => /*#__PURE__*/_react.default.createElement(SingleDocument, {
      href: singleDocHref,
      onClick: onOpenSingleDoc
    })
  }, {
    id: 'surroundingDocument',
    enabled: Boolean(!viewSurroundingDocument.disabled && dataView.isTimeBased() && dataView.id),
    Content: () => /*#__PURE__*/_react.default.createElement(SurroundingDocuments, {
      onClick: onOpenContextView,
      href: contextViewHref
    })
  }, ...customActions];
  const hasEnabledActions = flyoutActions.some(action => action.enabled);
  if (hasEnabledActions) {
    flyoutActions.unshift(staticViewDocumentItem);
  }
  return {
    flyoutActions,
    hasEnabledActions
  };
};
exports.useFlyoutActions = useFlyoutActions;
const ViewDocument = () => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiHideFor, {
    sizes: ['xs', 's', 'm']
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("strong", null, _i18n.i18n.translate('discover.grid.tableRow.viewText', {
    defaultMessage: 'View:'
  })))));
};
const SingleDocument = props => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, (0, _extends2.default)({
    size: "s",
    iconSize: "s",
    iconType: "document",
    flush: "left",
    "data-test-subj": "docTableRowAction"
  }, props), _i18n.i18n.translate('discover.grid.tableRow.viewSingleDocumentLinkTextSimple', {
    defaultMessage: 'Single document'
  })));
};
const SurroundingDocuments = props => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    responsive: false,
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, (0, _extends2.default)({
    size: "s",
    iconSize: "s",
    iconType: "documents",
    flush: "left",
    "data-test-subj": "docTableRowAction"
  }, props), _i18n.i18n.translate('discover.grid.tableRow.viewSurroundingDocumentsLinkTextSimple', {
    defaultMessage: 'Surrounding documents'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: _i18n.i18n.translate('discover.grid.tableRow.viewSurroundingDocumentsHover', {
      defaultMessage: 'Inspect documents that occurred before and after this document. Only pinned filters remain active in the Surrounding documents view.'
    }),
    type: "questionInCircle",
    color: "subdued",
    position: "right",
    iconProps: {
      className: 'eui-alignTop'
    }
  })));
};