"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAdHocDataViews = void 0;
var _react = require("react");
var _analytics = require("@kbn/analytics");
var _discover_state_provider = require("../services/discover_state_provider");
var _is_text_based_query = require("../utils/is_text_based_query");
var _discover_app_state_container = require("../services/discover_app_state_container");
var _discover_internal_state_container = require("../services/discover_internal_state_container");
var _constants = require("../../../constants");
var _use_filters_validation = require("./use_filters_validation");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const useAdHocDataViews = ({
  services
}) => {
  const query = (0, _discover_app_state_container.useAppStateSelector)(state => state.query);
  const dataView = (0, _discover_internal_state_container.useInternalStateSelector)(state => state.dataView);
  const savedSearch = (0, _discover_state_provider.useSavedSearch)();
  const isTextBasedMode = (0, _is_text_based_query.isTextBasedQuery)(query);
  const {
    filterManager,
    toastNotifications
  } = services;
  (0, _react.useEffect)(() => {
    if (dataView && !dataView.isPersisted()) {
      var _services$trackUiMetr;
      (_services$trackUiMetr = services.trackUiMetric) === null || _services$trackUiMetr === void 0 ? void 0 : _services$trackUiMetr.call(services, _analytics.METRIC_TYPE.COUNT, _constants.ADHOC_DATA_VIEW_RENDER_EVENT);
    }
  }, [dataView, isTextBasedMode, services]);

  /**
   * Takes care of checking data view id references in filters
   */
  (0, _use_filters_validation.useFiltersValidation)({
    savedSearch,
    filterManager,
    toastNotifications
  });
};
exports.useAdHocDataViews = useAdHocDataViews;