"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiscoverUninitialized = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const DiscoverUninitialized = ({
  onRefresh
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "discoverApp",
    title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "discover.uninitializedTitle",
      defaultMessage: "Start searching"
    })),
    body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "discover.uninitializedText",
      defaultMessage: "Write a query, add some filters, or simply hit Refresh to retrieve results for the current query."
    })),
    actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "primary",
      fill: true,
      onClick: onRefresh,
      "data-test-subj": "refreshDataButton"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "discover.uninitializedRefreshButtonText",
      defaultMessage: "Refresh data"
    }))
  });
};
exports.DiscoverUninitialized = DiscoverUninitialized;