"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocumentExplorerCallout = exports.CALLOUT_STATE_KEY = void 0;
var _react = _interopRequireWildcard(require("react"));
require("./document_explorer_callout.scss");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _discoverUtils = require("@kbn/discover-utils");
var _use_discover_services = require("../../../../hooks/use_discover_services");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const CALLOUT_STATE_KEY = 'discover:docExplorerCalloutClosed';
exports.CALLOUT_STATE_KEY = CALLOUT_STATE_KEY;
const getStoredCalloutState = storage => {
  const calloutClosed = storage.get(CALLOUT_STATE_KEY);
  return Boolean(calloutClosed);
};
const updateStoredCalloutState = (newState, storage) => {
  storage.set(CALLOUT_STATE_KEY, newState);
};

/**
 * The callout that's displayed when Document explorer is disabled
 */
const DocumentExplorerCallout = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    storage,
    capabilities,
    docLinks,
    addBasePath
  } = (0, _use_discover_services.useDiscoverServices)();
  const [calloutClosed, setCalloutClosed] = (0, _react.useState)(getStoredCalloutState(storage));
  const onCloseCallout = (0, _react.useCallback)(() => {
    updateStoredCalloutState(true, storage);
    setCalloutClosed(true);
  }, [storage]);
  const semiBoldStyle = (0, _react.useMemo)(() => (0, _react2.css)`
      font-weight: ${euiTheme.font.weight.semiBold};
    `, [euiTheme.font.weight.semiBold]);
  if (calloutClosed || !capabilities.advancedSettings.save) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "dscDocumentExplorerLegacyCallout",
    className: "dscDocumentExplorerCallout",
    title: /*#__PURE__*/_react.default.createElement(CalloutTitle, {
      onCloseCallout: onCloseCallout
    }),
    iconType: "search"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.docExplorerCallout.bodyMessage",
    defaultMessage: "Quickly sort, select, and compare data, resize columns, and view documents in fullscreen with the {documentExplorer}.",
    values: {
      documentExplorer: /*#__PURE__*/_react.default.createElement("span", {
        css: semiBoldStyle
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "discover.docExplorerCallout.documentExplorer",
        defaultMessage: "Document Explorer"
      }))
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexStart",
    alignItems: "center",
    responsive: false,
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "tryDocumentExplorerButton",
    iconType: "tableDensityNormal",
    size: "s",
    href: addBasePath(`/app/management/kibana/settings?query=${_discoverUtils.DOC_TABLE_LEGACY}`)
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.docExplorerCallout.tryDocumentExplorer",
    defaultMessage: "Try Document Explorer"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: docLinks.links.discover.documentExplorer,
    target: "_blank"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.docExplorerCallout.learnMore",
    defaultMessage: "Learn more"
  })))));
};
exports.DocumentExplorerCallout = DocumentExplorerCallout;
function CalloutTitle({
  onCloseCallout
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    gutterSize: "none",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.docExplorerCallout.headerMessage",
    defaultMessage: "A better way to explore"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": _i18n.i18n.translate('discover.docExplorerCallout.closeButtonAriaLabel', {
      defaultMessage: 'Close'
    }),
    "data-test-subj": "dscExplorerCalloutClose",
    onClick: onCloseCallout,
    type: "button",
    iconType: "cross"
  })));
}