"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dataStreamService = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class DataStreamService {
  streamPartsToIndexPattern({
    type,
    dataset
  }) {
    return `${type}-${dataset}`;
  }
  async getMatchingDataStreams(esClient, dataStreamParts) {
    try {
      const {
        data_streams: dataStreamsInfo
      } = await esClient.indices.getDataStream({
        name: this.streamPartsToIndexPattern(dataStreamParts)
      });
      return dataStreamsInfo;
    } catch (e) {
      if (e.statusCode === 404) {
        return [];
      }
      throw e;
    }
  }
  async getMatchingDataStreamsStats(esClient, dataStreamParts) {
    try {
      const {
        data_streams: dataStreamsStats
      } = await esClient.indices.dataStreamsStats({
        name: this.streamPartsToIndexPattern(dataStreamParts),
        human: true
      });
      return dataStreamsStats;
    } catch (e) {
      if (e.statusCode === 404) {
        return [];
      }
      throw e;
    }
  }
}
const dataStreamService = new DataStreamService();
exports.dataStreamService = dataStreamService;