"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QualityIndicator = QualityIndicator;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function QualityIndicator({
  quality
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const qualityColors = {
    poor: euiTheme.colors.dangerText,
    degraded: euiTheme.colors.warningText,
    good: euiTheme.colors.successText
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "dot",
    color: qualityColors[quality]
  });
}