"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createDatasetQuality = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _data_streams_stats_service = require("../../services/data_streams_stats/data_streams_stats_service");
var _context = require("./context");
var _utils = require("../../utils");
var _header = require("./header");
var _table = require("./table");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createDatasetQuality = ({
  core,
  plugins
}) => {
  return () => {
    const KibanaContextProviderForPlugin = (0, _utils.useKibanaContextForPluginProvider)(core, plugins);
    const dataStreamsStatsServiceClient = new _data_streams_stats_service.DataStreamsStatsService().start({
      http: core.http
    }).client;
    const datasetQualityProviderValue = {
      dataStreamsStatsServiceClient
    };
    return /*#__PURE__*/_react.default.createElement(_context.DatasetQualityContext.Provider, {
      value: datasetQualityProviderValue
    }, /*#__PURE__*/_react.default.createElement(KibanaContextProviderForPlugin, null, /*#__PURE__*/_react.default.createElement(DatasetQuality, null)));
  };
};
exports.createDatasetQuality = createDatasetQuality;
function DatasetQuality() {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_header.Header, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_table.Table, null)));
}