"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataVisualizerFieldTypeFilter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _fieldUtils = require("@kbn/field-utils");
var _use_current_eui_theme = require("../../../common/hooks/use_current_eui_theme");
var _field_types_help_popover = require("../../../common/components/field_types_filter/field_types_help_popover");
var _field_type_icon = require("../../../common/components/field_type_icon");
var _multi_select_picker = require("../../../common/components/multi_select_picker");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DataVisualizerFieldTypeFilter = ({
  indexedFieldTypes,
  setVisibleFieldTypes,
  visibleFieldTypes
}) => {
  const euiTheme = (0, _use_current_eui_theme.useCurrentEuiTheme)();
  const options = (0, _react.useMemo)(() => {
    return indexedFieldTypes.map(indexedFieldName => {
      var _getFieldTypeName;
      const label = (_getFieldTypeName = (0, _fieldUtils.getFieldTypeName)(indexedFieldName)) !== null && _getFieldTypeName !== void 0 ? _getFieldTypeName : indexedFieldName;
      return {
        value: indexedFieldName,
        name: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: true
        }, " ", label), indexedFieldName && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false
        }, /*#__PURE__*/_react.default.createElement(_field_type_icon.FieldTypeIcon, {
          type: indexedFieldName,
          tooltipEnabled: false
        })))
      };
    });
  }, [indexedFieldTypes]);
  const fieldTypeTitle = (0, _react.useMemo)(() => _i18n.i18n.translate('xpack.dataVisualizer.index.fieldTypeSelect', {
    defaultMessage: 'Field type'
  }), []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_multi_select_picker.MultiSelectPicker, {
    title: fieldTypeTitle,
    options: options,
    onChange: setVisibleFieldTypes,
    checkedOptions: visibleFieldTypes,
    dataTestSubj: 'dataVisualizerFieldTypeSelect',
    postfix: /*#__PURE__*/_react.default.createElement(_field_types_help_popover.FieldTypesHelpPopover, {
      fieldTypes: indexedFieldTypes
    }),
    cssStyles: {
      filterGroup: (0, _react2.css)`
            margin-left: ${euiTheme.euiSizeS};
          `
    }
  }));
};
exports.DataVisualizerFieldTypeFilter = DataVisualizerFieldTypeFilter;