"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UNSUPPORTED_LABEL = exports.REFERENCE_LABEL = exports.NUMERIC_TYPE_LABEL = exports.DRIFT_P_VALUE_THRESHOLD = exports.DATA_COMPARISON_TYPE_LABEL = exports.DATA_COMPARISON_TYPE = exports.COMPARISON_LABEL = exports.CATEGORICAL_TYPE_LABEL = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DATA_COMPARISON_TYPE = {
  NUMERIC: 'numeric',
  CATEGORICAL: 'categorical',
  UNSUPPORTED: 'unsupported'
};
exports.DATA_COMPARISON_TYPE = DATA_COMPARISON_TYPE;
const NUMERIC_TYPE_LABEL = _i18n.i18n.translate('xpack.dataVisualizer.dataDrift.numericLabel', {
  defaultMessage: 'Numeric'
});
exports.NUMERIC_TYPE_LABEL = NUMERIC_TYPE_LABEL;
const CATEGORICAL_TYPE_LABEL = _i18n.i18n.translate('xpack.dataVisualizer.dataDrift.categoricalLabel', {
  defaultMessage: 'Categorical'
});
exports.CATEGORICAL_TYPE_LABEL = CATEGORICAL_TYPE_LABEL;
const UNSUPPORTED_LABEL = _i18n.i18n.translate('xpack.dataVisualizer.dataDrift.UnsupportedLabel', {
  defaultMessage: 'Unsupported'
});
exports.UNSUPPORTED_LABEL = UNSUPPORTED_LABEL;
const REFERENCE_LABEL = _i18n.i18n.translate('xpack.dataVisualizer.dataDrift.referenceLabel', {
  defaultMessage: 'Reference'
});
exports.REFERENCE_LABEL = REFERENCE_LABEL;
const COMPARISON_LABEL = _i18n.i18n.translate('xpack.dataVisualizer.dataDrift.comparisonLabel', {
  defaultMessage: 'Comparison'
});
exports.COMPARISON_LABEL = COMPARISON_LABEL;
const DATA_COMPARISON_TYPE_LABEL = {
  [DATA_COMPARISON_TYPE.NUMERIC]: NUMERIC_TYPE_LABEL,
  [DATA_COMPARISON_TYPE.CATEGORICAL]: CATEGORICAL_TYPE_LABEL,
  [DATA_COMPARISON_TYPE.UNSUPPORTED]: UNSUPPORTED_LABEL
};
exports.DATA_COMPARISON_TYPE_LABEL = DATA_COMPARISON_TYPE_LABEL;
const DRIFT_P_VALUE_THRESHOLD = 0.05;
exports.DRIFT_P_VALUE_THRESHOLD = DRIFT_P_VALUE_THRESHOLD;