"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MultiSelectPicker = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _use_current_eui_theme = require("../../hooks/use_current_eui_theme");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SELECT_PICKER_HEIGHT = '250px';
const NoFilterItems = () => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSelectableMessage, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "minusInCircle"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.multiSelectPicker.NoFiltersFoundMessage",
    defaultMessage: "No filters found"
  })));
};
const MultiSelectPicker = ({
  options,
  onChange,
  title,
  checkedOptions,
  dataTestSubj,
  postfix,
  cssStyles
}) => {
  var _cssStyles$filterItem;
  const euiTheme = (0, _use_current_eui_theme.useCurrentEuiTheme)();
  const [items, setItems] = (0, _react.useState)(options);
  const [searchTerm, setSearchTerm] = (0, _react.useState)('');
  (0, _react.useEffect)(() => {
    if (searchTerm === '') {
      setItems(options);
    } else {
      const filteredOptions = options.filter(o => {
        var _o$value;
        return o === null || o === void 0 ? void 0 : (_o$value = o.value) === null || _o$value === void 0 ? void 0 : _o$value.includes(searchTerm);
      });
      setItems(filteredOptions);
    }
  }, [options, searchTerm]);
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const onButtonClick = () => {
    setIsPopoverOpen(!isPopoverOpen);
  };
  const closePopover = () => {
    setIsPopoverOpen(false);
    setSearchTerm('');
  };
  const handleOnChange = index => {
    if (!items[index] || !Array.isArray(checkedOptions) || onChange === undefined) {
      return;
    }
    const item = items[index];
    const foundIndex = checkedOptions.findIndex(fieldValue => fieldValue === item.value);
    if (foundIndex > -1) {
      onChange(checkedOptions.filter((_, idx) => idx !== foundIndex));
    } else {
      onChange([...checkedOptions, item.value]);
    }
  };
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    "data-test-subj": `${dataTestSubj}-button`,
    iconType: "arrowDown",
    onClick: onButtonClick,
    isSelected: isPopoverOpen,
    numFilters: items.length,
    hasActiveFilters: checkedOptions && checkedOptions.length > 0,
    numActiveFilters: checkedOptions && checkedOptions.length
  }, title);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, {
    "data-test-subj": dataTestSubj,
    css: cssStyles === null || cssStyles === void 0 ? void 0 : cssStyles.filterGroup
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    ownFocus: true,
    "data-test-subj": `${dataTestSubj}-popover`,
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    compressed: true,
    onChange: e => setSearchTerm(e.target.value),
    "data-test-subj": `${dataTestSubj}-searchInput`
  })), /*#__PURE__*/_react.default.createElement("div", {
    css: (_cssStyles$filterItem = cssStyles === null || cssStyles === void 0 ? void 0 : cssStyles.filterItemContainer) !== null && _cssStyles$filterItem !== void 0 ? _cssStyles$filterItem : (0, _react2.css)`
              max-height: ${SELECT_PICKER_HEIGHT};
              overflow: auto;
            `
  }, Array.isArray(items) && items.length > 0 ? items.map((item, index) => {
    var _item$name;
    const checked = checkedOptions && checkedOptions.findIndex(fieldValue => fieldValue === item.value) > -1;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFilterSelectItem, {
      checked: checked ? 'on' : undefined,
      key: index,
      onClick: () => handleOnChange(index),
      style: {
        flexDirection: 'row',
        color: item.disabled === true ? euiTheme.euiColorDisabledText : euiTheme.euiTextColor
      },
      "data-test-subj": `${dataTestSubj}-option-${item.value}${checked ? '-checked' : ''}`
    }, (_item$name = item.name) !== null && _item$name !== void 0 ? _item$name : item.value);
  }) : /*#__PURE__*/_react.default.createElement(NoFilterItems, null))), postfix ? postfix : null);
};
exports.MultiSelectPicker = MultiSelectPicker;