"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatusMessage = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const NoMatchStatusMessage = allIndicesLength => /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "indexPatternEditor.status.notMatchLabel.notMatchDetail",
  defaultMessage: "The index pattern you entered doesn't match any data streams, indices, or index aliases. You can match {strongIndices}.",
  values: {
    strongIndices: /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "indexPatternEditor.status.notMatchLabel.allIndicesLabel",
      defaultMessage: "{indicesLength, plural, one {# source} other {# sources} }",
      values: {
        indicesLength: allIndicesLength
      }
    }))
  }
}));
const NoMatchNoIndicesStatusMessage = () => /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "indexPatternEditor.status.notMatchLabel.notMatchNoIndicesDetail",
  defaultMessage: "The index pattern you entered doesn't match any data streams, indices, or index aliases."
}));
const StatusMessage = ({
  matchedIndices: {
    allIndices = [],
    exactMatchedIndices = [],
    partialMatchedIndices = []
  },
  isIncludingSystemIndices,
  query,
  showSystemIndices
}) => {
  let statusIcon;
  let statusMessage;
  let statusColor;
  const allIndicesLength = allIndices.length;
  if (query.length === 0) {
    statusIcon = undefined;
    statusColor = 'primary';
    if (allIndicesLength >= 1) {
      statusMessage = /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "indexPatternEditor.status.matchAnyLabel.matchAnyDetail",
        defaultMessage: "Your index pattern can match {sourceCount, plural, one {# source} other {# sources} }.",
        values: {
          sourceCount: allIndicesLength
        }
      }));
    } else if (!isIncludingSystemIndices && showSystemIndices) {
      statusMessage = /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "indexPatternEditor.status.noSystemIndicesWithPromptLabel",
        defaultMessage: "No data streams, indices, or index aliases match your index pattern."
      }));
    } else {
      statusMessage = /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "indexPatternEditor.status.noSystemIndicesLabel",
        defaultMessage: "No data streams, indices, or index aliases match your index pattern."
      }));
    }
  } else if (exactMatchedIndices.length) {
    statusIcon = 'check';
    statusColor = 'success';
    statusMessage = /*#__PURE__*/_react.default.createElement("span", null, "\xA0", /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "indexPatternEditor.status.successLabel.successDetail",
      defaultMessage: "Your index pattern matches {sourceCount} {sourceCount, plural, one {source} other {sources} }.",
      values: {
        sourceCount: exactMatchedIndices.length
      }
    }));
  } else if (partialMatchedIndices.length) {
    statusIcon = undefined;
    statusColor = 'primary';
    statusMessage = /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "indexPatternEditor.status.partialMatchLabel.partialMatchDetail",
      defaultMessage: "Your index pattern doesn't match any data streams, indices, or index aliases, but {strongIndices} {matchedIndicesLength, plural, one {is} other {are} } similar.",
      values: {
        matchedIndicesLength: partialMatchedIndices.length,
        strongIndices: /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "indexPatternEditor.status.partialMatchLabel.strongIndicesLabel",
          defaultMessage: "{matchedIndicesLength, plural, one {source} other {# sources} }",
          values: {
            matchedIndicesLength: partialMatchedIndices.length
          }
        }))
      }
    }));
  } else {
    statusIcon = undefined;
    statusColor = 'warning';
    statusMessage = allIndicesLength ? NoMatchStatusMessage(allIndicesLength) : NoMatchNoIndicesStatusMessage();
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "s",
    color: statusColor,
    "data-test-subj": "createIndexPatternStatusMessage",
    iconType: statusIcon,
    title: statusMessage
  });
};
exports.StatusMessage = StatusMessage;