"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimeHistory = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _moment = _interopRequireDefault(require("moment"));
var _persisted_log = require("../persisted_log");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class TimeHistory {
  constructor(storage) {
    (0, _defineProperty2.default)(this, "history", void 0);
    const historyOptions = {
      maxLength: 10,
      filterDuplicates: true,
      isDuplicate: (oldItem, newItem) => {
        return oldItem.from === newItem.from && oldItem.to === newItem.to;
      }
    };
    this.history = new _persisted_log.PersistedLog('kibana.timepicker.timeHistory', historyOptions, storage);
  }
  add(time) {
    if (!time || !time.from || !time.to) {
      return;
    }

    // time from/to can be strings or moment objects - convert to strings so always dealing with same types
    const justStringsTime = {
      from: _moment.default.isMoment(time.from) ? time.from.toISOString() : time.from,
      to: _moment.default.isMoment(time.to) ? time.to.toISOString() : time.to
    };
    this.history.add(justStringsTime);
  }
  get() {
    return this.history.get();
  }
  get$() {
    return this.history.get$();
  }
}
exports.TimeHistory = TimeHistory;