"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.applicationServiceFactory = void 0;
var _coreApplicationBrowserMocks = require("@kbn/core-application-browser-mocks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const applicationServiceFactory = () => {
  const pluginMock = _coreApplicationBrowserMocks.applicationServiceMock.createStartContract();
  return {
    currentAppId$: pluginMock.currentAppId$,
    navigateToApp: pluginMock.navigateToApp,
    navigateToUrl: pluginMock.navigateToUrl,
    getUrlForApp: pluginMock.getUrlForApp,
    capabilities: {
      advancedSettings: pluginMock.capabilities.advancedSettings,
      maps: pluginMock.capabilities.maps,
      navLinks: pluginMock.capabilities.navLinks,
      visualize: pluginMock.capabilities.visualize
    }
  };
};
exports.applicationServiceFactory = applicationServiceFactory;