"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.DashboardListingTable = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _contentManagementTableListViewTable = require("@kbn/content-management-table-list-view-table");
var _public = require("@kbn/kibana-react-plugin/public");
var _plugin_services = require("../services/plugin_services");
var _dashboard_unsaved_listing = require("./dashboard_unsaved_listing");
var _use_dashboard_listing_table = require("./hooks/use_dashboard_listing_table");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const DashboardListingTable = ({
  disableCreateDashboardButton,
  initialFilter,
  goToDashboard,
  getDashboardUrl,
  useSessionStorageIntegration,
  urlStateEnabled,
  showCreateDashboardButton = true
}) => {
  const {
    application,
    notifications,
    overlays,
    http,
    savedObjectsTagging,
    coreContext: {
      executionContext
    },
    chrome: {
      theme
    }
  } = _plugin_services.pluginServices.getServices();
  (0, _public.useExecutionContext)(executionContext, {
    type: 'application',
    page: 'list'
  });
  const {
    unsavedDashboardIds,
    refreshUnsavedDashboards,
    tableListViewTableProps: {
      title: tableCaption,
      ...tableListViewTable
    }
  } = (0, _use_dashboard_listing_table.useDashboardListingTable)({
    disableCreateDashboardButton,
    goToDashboard,
    getDashboardUrl,
    urlStateEnabled,
    useSessionStorageIntegration,
    initialFilter,
    showCreateDashboardButton
  });
  const savedObjectsTaggingFakePlugin = (0, _react.useMemo)(() => savedObjectsTagging.hasApi // TODO: clean up this logic once https://github.com/elastic/kibana/issues/140433 is resolved
  ? {
    ui: savedObjectsTagging
  } : undefined, [savedObjectsTagging]);
  const core = (0, _react.useMemo)(() => ({
    application: application,
    notifications,
    overlays,
    http,
    theme
  }), [application, notifications, overlays, http, theme]);
  return /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(_contentManagementTableListViewTable.TableListViewKibanaProvider, {
    core: core,
    toMountPoint: _public.toMountPoint,
    savedObjectsTagging: savedObjectsTaggingFakePlugin,
    FormattedRelative: _i18nReact.FormattedRelative
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_dashboard_unsaved_listing.DashboardUnsavedListing, {
    goToDashboard: goToDashboard,
    unsavedDashboardIds: unsavedDashboardIds,
    refreshUnsavedDashboards: refreshUnsavedDashboards
  }), /*#__PURE__*/_react.default.createElement(_contentManagementTableListViewTable.TableListViewTable, (0, _extends2.default)({
    tableCaption: tableCaption
  }, tableListViewTable)))));
};

// eslint-disable-next-line import/no-default-export
exports.DashboardListingTable = DashboardListingTable;
var _default = DashboardListingTable;
exports.default = _default;