"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addFromLibrary = addFromLibrary;
var _public = require("@kbn/embeddable-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function addFromLibrary() {
  if ((0, _public.isErrorEmbeddable)(this)) return;
  this.openOverlay((0, _public.openAddPanelFlyout)({
    container: this,
    onAddPanel: id => {
      this.setScrollToPanelId(id);
      this.setHighlightPanelId(id);
    },
    onClose: () => {
      this.clearOverlays();
    }
  }));
}