"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardEditingToolbar = DashboardEditingToolbar;
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _analytics = require("@kbn/analytics");
var _eui = require("@elastic/eui");
var _sharedUxButtonToolbar = require("@kbn/shared-ux-button-toolbar");
var _public = require("@kbn/embeddable-plugin/public");
var _dashboard_app_strings = require("../_dashboard_app_strings");
var _editor_menu = require("./editor_menu");
var _dashboard_app = require("../dashboard_app");
var _plugin_services = require("../../services/plugin_services");
var _controls_toolbar_button = require("./controls_toolbar_button");
var _dashboard_constants = require("../../dashboard_constants");
var _dashboard_actions_strings = require("../../dashboard_actions/_dashboard_actions_strings");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function DashboardEditingToolbar({
  isDisabled
}) {
  var _usageCollection$repo;
  const {
    usageCollection,
    data: {
      search
    },
    notifications: {
      toasts
    },
    embeddable: {
      getStateTransfer
    },
    visualizations: {
      getAliases: getVisTypeAliases
    }
  } = _plugin_services.pluginServices.getServices();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const dashboard = (0, _dashboard_app.useDashboardAPI)();
  const stateTransferService = getStateTransfer();
  const lensAlias = getVisTypeAliases().find(({
    name
  }) => name === 'lens');
  const trackUiMetric = (_usageCollection$repo = usageCollection.reportUiCounter) === null || _usageCollection$repo === void 0 ? void 0 : _usageCollection$repo.bind(usageCollection, _dashboard_constants.DASHBOARD_UI_METRIC_ID);
  const createNewVisType = (0, _react2.useCallback)(visType => () => {
    var _dashboard$getAppCont, _dashboard$getAppCont2, _dashboard$getAppCont3;
    let path = '';
    let appId = '';
    if (visType) {
      if (trackUiMetric) {
        trackUiMetric(_analytics.METRIC_TYPE.CLICK, `${visType.name}:create`);
      }
      if (!('alias' in visType)) {
        // this visualization is not an alias
        appId = 'visualize';
        path = `#/create?type=${encodeURIComponent(visType.name)}`;
      } else if (visType.alias && 'path' in visType.alias) {
        // this visualization **is** an alias, and it has an app to redirect to for creation
        appId = visType.alias.app;
        path = visType.alias.path;
      }
    } else {
      appId = 'visualize';
      path = '#/create?';
    }
    stateTransferService.navigateToEditor(appId, {
      path,
      state: {
        originatingApp: (_dashboard$getAppCont = dashboard.getAppContext()) === null || _dashboard$getAppCont === void 0 ? void 0 : _dashboard$getAppCont.currentAppId,
        originatingPath: (_dashboard$getAppCont2 = dashboard.getAppContext()) === null || _dashboard$getAppCont2 === void 0 ? void 0 : (_dashboard$getAppCont3 = _dashboard$getAppCont2.getCurrentPath) === null || _dashboard$getAppCont3 === void 0 ? void 0 : _dashboard$getAppCont3.call(_dashboard$getAppCont2),
        searchSessionId: search.session.getSessionId()
      }
    });
  }, [stateTransferService, dashboard, search.session, trackUiMetric]);
  const createNewEmbeddable = (0, _react2.useCallback)(async embeddableFactory => {
    if (trackUiMetric) {
      trackUiMetric(_analytics.METRIC_TYPE.CLICK, embeddableFactory.type);
    }
    let explicitInput;
    let attributes;
    try {
      const explicitInputReturn = await embeddableFactory.getExplicitInput(undefined, dashboard);
      if ((0, _public.isExplicitInputWithAttributes)(explicitInputReturn)) {
        explicitInput = explicitInputReturn.newInput;
        attributes = explicitInputReturn.attributes;
      } else {
        explicitInput = explicitInputReturn;
      }
    } catch (e) {
      // error likely means user canceled embeddable creation
      return;
    }
    const newEmbeddable = await dashboard.addNewEmbeddable(embeddableFactory.type, explicitInput, attributes);
    if (newEmbeddable) {
      dashboard.setScrollToPanelId(newEmbeddable.id);
      dashboard.setHighlightPanelId(newEmbeddable.id);
      toasts.addSuccess({
        title: _dashboard_actions_strings.dashboardReplacePanelActionStrings.getSuccessMessage(newEmbeddable.getTitle()),
        'data-test-subj': 'addEmbeddableToDashboardSuccess'
      });
    }
  }, [trackUiMetric, dashboard, toasts]);
  const extraButtons = [/*#__PURE__*/_react2.default.createElement(_editor_menu.EditorMenu, {
    createNewVisType: createNewVisType,
    createNewEmbeddable: createNewEmbeddable,
    isDisabled: isDisabled
  }), /*#__PURE__*/_react2.default.createElement(_sharedUxButtonToolbar.AddFromLibraryButton, {
    onClick: () => dashboard.addFromLibrary(),
    size: "s",
    "data-test-subj": "dashboardAddFromLibraryButton",
    isDisabled: isDisabled
  })];
  if (dashboard.controlGroup) {
    extraButtons.push( /*#__PURE__*/_react2.default.createElement(_controls_toolbar_button.ControlsToolbarButton, {
      isDisabled: isDisabled,
      controlGroup: dashboard.controlGroup
    }));
  }
  return /*#__PURE__*/_react2.default.createElement("div", {
    css: (0, _react.css)`
        padding: 0 ${euiTheme.size.s} ${euiTheme.size.s} ${euiTheme.size.s};
      `
  }, /*#__PURE__*/_react2.default.createElement(_sharedUxButtonToolbar.Toolbar, null, {
    primaryButton: /*#__PURE__*/_react2.default.createElement(_sharedUxButtonToolbar.ToolbarButton, {
      type: "primary",
      isDisabled: isDisabled,
      iconType: "lensApp",
      size: "s",
      onClick: createNewVisType(lensAlias),
      label: (0, _dashboard_app_strings.getCreateVisualizationButtonTitle)(),
      "data-test-subj": "dashboardAddNewPanelButton"
    }),
    extraButtons
  }));
}